/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.model.layer.util;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.layer.util.Extent;
import de.terrestris.shogun2.model.layer.util.Resolution;
import java.awt.geom.Point2D;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table
public class WmsTileGrid
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String type;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="x", column=@Column(name="TILEGRIDORIGIN_X")), @AttributeOverride(name="y", column=@Column(name="TILEGRIDORIGIN_Y"))})
    private Point2D.Double tileGridOrigin;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Extent tileGridExtent;
    private Integer tileSize;
    @ManyToMany
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @JoinTable(joinColumns={@JoinColumn(name="WMSTILEGRID_ID")}, inverseJoinColumns={@JoinColumn(name="RESOLUTION_ID")})
    @OrderColumn(name="IDX")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="resolution")
    @JsonIdentityReference(alwaysAsId=true)
    private List<Resolution> tileGridResolutions;

    public WmsTileGrid() {
        this.tileSize = new Integer(256);
    }

    public WmsTileGrid(Point2D.Double tileGridOrigin, Extent tileGridExtent, Integer tileSize) {
        this.tileGridOrigin = tileGridOrigin;
        this.tileGridExtent = tileGridExtent;
        this.tileSize = tileSize;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Point2D.Double getTileGridOrigin() {
        return this.tileGridOrigin;
    }

    public void setTileGridOrigin(Point2D.Double tileGridOrigin) {
        this.tileGridOrigin = tileGridOrigin;
    }

    public Extent getTileGridExtent() {
        return this.tileGridExtent;
    }

    public void setTileGridExtent(Extent tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
    }

    public Integer getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Integer tileSize) {
        this.tileSize = tileSize;
    }

    public List<Resolution> getTileGridResolutions() {
        return this.tileGridResolutions;
    }

    public void setTileGridResolutions(List<Resolution> tileGridResolutions) {
        this.tileGridResolutions = tileGridResolutions;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(43, 13).appendSuper(super.hashCode()).append((Object)this.getType()).append((Object)this.getTileSize()).append((Object)this.getTileGridOrigin()).append((Object)this.getTileGridExtent()).append(this.getTileGridResolutions()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WmsTileGrid)) {
            return false;
        }
        WmsTileGrid other = (WmsTileGrid)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getType(), (Object)other.getType()).append((Object)this.getTileGridExtent(), (Object)other.getTileGridExtent()).append((Object)this.getTileGridOrigin(), (Object)other.getTileGridOrigin()).append((Object)this.getTileSize(), (Object)other.getTileSize()).append(this.getTileGridResolutions(), other.getTileGridResolutions()).isEquals();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

