/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.model.layer.source;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.terrestris.shogun2.model.layer.source.LayerDataSource;
import de.terrestris.shogun2.model.layer.util.GeoWebServiceLayerName;
import de.terrestris.shogun2.model.layer.util.GeoWebServiceLayerStyle;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table
public class ImageWmsLayerDataSource
extends LayerDataSource {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private String version;
    @ManyToMany
    @JoinTable(name="IMAGEWMSLAYERDATASRC_LAYERNAME", joinColumns={@JoinColumn(name="IMAGEWMSLAYERDATASOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="LAYERNAME_ID")})
    @OrderColumn(name="IDX")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="layerName")
    @JsonIdentityReference(alwaysAsId=true)
    private List<GeoWebServiceLayerName> layerNames;
    @ManyToMany
    @JoinTable(name="IMAGEWMSLAYERDATASOURCE_STYLE", joinColumns={@JoinColumn(name="IMAGEWMSLAYERDATASOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="STYLE_ID")})
    @OrderColumn(name="IDX")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="styleName")
    @JsonIdentityReference(alwaysAsId=true)
    private List<GeoWebServiceLayerStyle> layerStyles;

    public ImageWmsLayerDataSource() {
    }

    public ImageWmsLayerDataSource(String name, String type, String url, int width, int height, String version, List<GeoWebServiceLayerName> layerNames, List<GeoWebServiceLayerStyle> layerStyles) {
        super(name, type, url);
        this.width = width;
        this.height = height;
        this.version = version;
        this.layerNames = layerNames;
        this.layerStyles = layerStyles;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<GeoWebServiceLayerName> getLayerNames() {
        return this.layerNames;
    }

    public void setLayerNames(List<GeoWebServiceLayerName> layerNames) {
        this.layerNames = layerNames;
    }

    public List<GeoWebServiceLayerStyle> getLayerStyles() {
        return this.layerStyles;
    }

    public void setLayerStyles(List<GeoWebServiceLayerStyle> layerStyles) {
        this.layerStyles = layerStyles;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(41, 13).appendSuper(super.hashCode()).append(this.getWidth()).append(this.getHeight()).append((Object)this.getVersion()).append(this.getLayerNames()).append(this.getLayerStyles()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ImageWmsLayerDataSource)) {
            return false;
        }
        ImageWmsLayerDataSource other = (ImageWmsLayerDataSource)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.getWidth(), other.getWidth()).append(this.getHeight(), other.getHeight()).append((Object)this.getVersion(), (Object)other.getVersion()).append(this.getLayerNames(), other.getLayerNames()).append(this.getLayerStyles(), other.getLayerStyles()).isEquals();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

