/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.taimos.dvalin.interconnect.model.InterconnectList;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.daemon.VoidIVO;
import de.taimos.dvalin.interconnect.model.service.DaemonError;
import de.taimos.dvalin.interconnect.model.service.DaemonReceiverMethod;
import de.taimos.dvalin.interconnect.model.service.DaemonRequestMethod;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaemonScanner {
    private static final DaemonMethod NOT_A_DAEMON_METHOD_FLAG = new DaemonMethod(null, null, null, null, false, false);
    private static final Map<Method, DaemonMethod> CACHE = new ConcurrentHashMap<Method, DaemonMethod>();
    private static final Logger LOGGER2 = LoggerFactory.getLogger(DaemonScanner.class);

    public static Set<DaemonMethod> scan(Class<? extends IDaemonHandler> clazz) {
        HashSet<DaemonMethod> res = new HashSet<DaemonMethod>();
        for (Method method : clazz.getMethods()) {
            DaemonMethod dm = DaemonScanner.scan(method);
            if (dm == null) continue;
            if (res.contains(dm)) {
                throw new IllegalStateException("duplicate @DaemonRequestMethod");
            }
            res.add(dm);
        }
        return res;
    }

    public static DaemonMethod scan(Method method) {
        DaemonMethod cached = CACHE.get(method);
        if (cached != null) {
            if (cached == NOT_A_DAEMON_METHOD_FLAG) {
                return null;
            }
            return cached;
        }
        Annotation drm = DaemonScanner.getAnnotation(DaemonRequestMethod.class, method);
        if (drm != null) {
            DaemonMethod dm = DaemonScanner.scanRequest(method, drm);
            CACHE.put(method, dm);
            return dm;
        }
        drm = DaemonScanner.getAnnotation(DaemonReceiverMethod.class, method);
        if (drm != null) {
            DaemonMethod dm = DaemonScanner.scanReceiver(method, (DaemonReceiverMethod)drm);
            CACHE.put(method, dm);
            return dm;
        }
        return null;
    }

    private static <E extends Annotation> E isAnnotationPresent(Class<E> annotation, Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = clazz.getMethod(methodName, parameterTypes);
        if (method.isAnnotationPresent(annotation)) {
            return method.getAnnotation(annotation);
        }
        for (Class<?> interfaceClazz : clazz.getInterfaces()) {
            E e = DaemonScanner.isAnnotationPresent(annotation, interfaceClazz, methodName, parameterTypes);
            if (e == null) continue;
            return e;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && !Object.class.equals(superClazz)) {
            return DaemonScanner.isAnnotationPresent(annotation, superClazz, methodName, parameterTypes);
        }
        return null;
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> annotation, Method method) {
        Annotation e = DaemonScanner.getAnnotation(annotation, method);
        return e != null;
    }

    public static <A extends Annotation> A getAnnotation(Class<A> annotation, Method method) {
        try {
            return DaemonScanner.isAnnotationPresent(annotation, method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static DaemonMethod scanRequest(Method method, DaemonRequestMethod drm) {
        Type type;
        if (method.getParameterTypes().length != 1) {
            throw new IllegalStateException("@DaemonRequestMethod must have one parameter");
        }
        if (InterconnectObject.class.isAssignableFrom(method.getReturnType())) {
            if (!IVO.class.isAssignableFrom(method.getReturnType())) {
                LOGGER2.warn("The method " + method + " uses InterconnectObject (which is deprecated) instead of IVO return.");
            }
            if (method.getReturnType().isInterface()) {
                LOGGER2.warn("The method " + method + " returns an interface");
            }
            type = Type.interconnectObject;
        } else if (method.getReturnType().equals(Void.TYPE)) {
            type = Type.voidivo;
        } else if (InterconnectObject[].class.isAssignableFrom(method.getReturnType())) {
            if (!IVO[].class.isAssignableFrom(method.getReturnType())) {
                LOGGER2.warn("The method " + method + " uses InterconnectObject[] (which is deprecated) instead of IVO[] return.");
            }
            type = Type.interconnectObjects;
        } else if (List.class.isAssignableFrom(method.getReturnType())) {
            ParameterizedType t = (ParameterizedType)method.getGenericReturnType();
            if (t.getActualTypeArguments().length != 1) {
                throw new IllegalStateException("@DaemonRequestMethod return type must be List<InterconnectObject>");
            }
            java.lang.reflect.Type innerType = t.getActualTypeArguments()[0];
            Class typeClazz = null;
            typeClazz = innerType instanceof ParameterizedType ? (Class)((ParameterizedType)innerType).getRawType() : (Class)innerType;
            if (!InterconnectObject.class.isAssignableFrom(typeClazz)) {
                throw new IllegalStateException("@DaemonRequestMethod return type must be List<InterconnectObject>");
            }
            if (!IVO.class.isAssignableFrom(typeClazz)) {
                LOGGER2.warn("The method " + method + " uses List<? extends InterconnectObject> (which is deprecated) instead of List<? extends IVO> return.");
            }
            if (typeClazz.isInterface()) {
                LOGGER2.warn("The method " + method + " returns an interface");
            }
            type = Type.interconnectObjects;
        } else {
            throw new IllegalStateException("@DaemonRequestMethod return type must be: IVO, void, List<IVO> or IVO[]");
        }
        if ((method.getExceptionTypes().length != 1 || method.getExceptionTypes()[0] != DaemonError.class) && method.getDeclaringClass().isInterface()) {
            throw new IllegalStateException("@DaemonRequestMethod must throw exactly one exception of type DaemonError");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException("@DaemonRequestMethod must be public");
        }
        Class<?> paramClass = method.getParameterTypes()[0];
        if (!InterconnectObject.class.isAssignableFrom(paramClass)) {
            throw new IllegalStateException("Paramater of @DaemonRequestMethod must implement InterconnectObject");
        }
        if (!IVO.class.isAssignableFrom(paramClass)) {
            LOGGER2.warn("The method " + method + " uses InterconnectObject (which is deprecated) instead of IVO as input.");
        }
        if (paramClass.isInterface()) {
            throw new IllegalStateException("Paramater of @DaemonRequestMethod must not be an interface");
        }
        Class<?> icoClazz = method.getParameterTypes()[0];
        long timeoutInMs = drm.timeoutUnit().toMillis(drm.timeout());
        return new DaemonMethod(icoClazz, method, type, timeoutInMs, drm.secure(), drm.idempotent());
    }

    private static DaemonMethod scanReceiver(Method method, DaemonReceiverMethod drm) {
        if (method.getParameterTypes().length != 1) {
            throw new IllegalStateException("@DaemonReceiverMethod must have one parameter");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalStateException("@DaemonReceiverMethod must return void");
        }
        if (method.getExceptionTypes().length > 0) {
            throw new IllegalStateException("@DaemonReceiverMethod must not throw an exception");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException("@DaemonReceiverMethod must be public");
        }
        Class<?> paramClass = method.getParameterTypes()[0];
        if (!InterconnectObject.class.isAssignableFrom(paramClass)) {
            throw new IllegalStateException("Paramater of @DaemonReceiverMethod must implement InterconnectObject");
        }
        if (!IVO.class.isAssignableFrom(paramClass)) {
            LOGGER2.warn("The method " + method + " uses InterconnectObject (which is deprecated) instead of IVO as input.");
        }
        if (paramClass.isInterface()) {
            throw new IllegalStateException("Paramater of @DaemonReceiverMethod must not be an interface");
        }
        Class<?> icoClazz = method.getParameterTypes()[0];
        return new DaemonMethod(icoClazz, method, Type.voit, null, drm.secure(), drm.idempotent());
    }

    public static <T> T[] object2Array(Class<T> clazz, Object obj) {
        return (Object[])obj;
    }

    public static final class DaemonMethod {
        private final Class<? extends InterconnectObject> request;
        private final Method method;
        private final Type type;
        private final Long timeoutInMs;
        private final boolean secure;
        private final boolean idempotent;

        public DaemonMethod(Class<? extends InterconnectObject> aRequest, Method aMethod, Type aType, Long aTimeoutInMs, boolean aSecure, boolean anIdempotent) {
            this.request = aRequest;
            this.method = aMethod;
            this.type = aType;
            this.timeoutInMs = aTimeoutInMs;
            this.secure = aSecure;
            this.idempotent = anIdempotent;
        }

        @Deprecated
        public DaemonMethod(Class<? extends InterconnectObject> aRequest, Method aMethod, Type aType, Long aTimeoutInMs, boolean aSecure) {
            this(aRequest, aMethod, aType, aTimeoutInMs, aSecure, false);
        }

        public Class<? extends InterconnectObject> getRequest() {
            return this.request;
        }

        public Method getMethod() {
            return this.method;
        }

        public Type getType() {
            return this.type;
        }

        public Long getTimeoutInMs() {
            return this.timeoutInMs;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public boolean isIdempotent() {
            return this.idempotent;
        }

        public InterconnectObject invoke(IDaemonHandler handler, InterconnectObject ivo) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.getType().invoke(handler, this.getMethod(), ivo);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DaemonMethod other = (DaemonMethod)obj;
            return !(this.request == null ? other.request != null : !this.request.equals(other.request));
        }
    }

    public static enum Type implements Invoke
    {
        interconnectObject{

            @Override
            public InterconnectObject invoke(IDaemonHandler handler, Method method, InterconnectObject ico) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Object obj = method.invoke((Object)handler, ico);
                Preconditions.checkNotNull((Object)obj, (Object)"return must not be null");
                return (InterconnectObject)obj;
            }
        }
        ,
        interconnectObjects{

            @Override
            public InterconnectObject invoke(IDaemonHandler handler, Method method, InterconnectObject ico) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Object obj = method.invoke((Object)handler, ico);
                Preconditions.checkNotNull((Object)obj, (Object)"return must not be null");
                if (obj instanceof List) {
                    return new InterconnectList((List)obj);
                }
                if (obj.getClass().isArray()) {
                    ArrayList list = Lists.newArrayList((Object[])DaemonScanner.object2Array(obj.getClass().getEnclosingClass(), obj));
                    return new InterconnectList(list);
                }
                throw new IllegalAccessException("Invalid return value: " + obj);
            }
        }
        ,
        voidivo{

            @Override
            public InterconnectObject invoke(IDaemonHandler handler, Method method, InterconnectObject ico) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                method.invoke((Object)handler, ico);
                return new VoidIVO.VoidIVOBuilder().build();
            }
        }
        ,
        voit{

            @Override
            public InterconnectObject invoke(IDaemonHandler handler, Method method, InterconnectObject ico) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                method.invoke((Object)handler, ico);
                return null;
            }
        };

    }

    public static interface Invoke {
        public InterconnectObject invoke(IDaemonHandler var1, Method var2, InterconnectObject var3) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }
}

