/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.service;

import de.taimos.dvalin.interconnect.model.service.Daemon;
import de.taimos.dvalin.interconnect.model.service.DaemonErrorNumber;
import de.taimos.dvalin.interconnect.model.service.IDaemon;

public abstract class ADaemonErrorNumber
implements DaemonErrorNumber {
    private static final long serialVersionUID = 1L;
    private final int number;
    private final String daemon;

    public ADaemonErrorNumber(int aNumber, String aDaemon) {
        if (aDaemon == null) {
            throw new NullPointerException();
        }
        this.number = aNumber;
        this.daemon = aDaemon;
    }

    public ADaemonErrorNumber(int aNumber, Class<? extends IDaemon> daemonInterface) {
        if (daemonInterface == null) {
            throw new NullPointerException();
        }
        if (daemonInterface.getAnnotation(Daemon.class) == null) {
            throw new NullPointerException();
        }
        this.number = aNumber;
        this.daemon = daemonInterface.getAnnotation(Daemon.class).name();
    }

    @Override
    public final String daemon() {
        return this.daemon;
    }

    @Override
    public final int get() {
        return this.number;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.daemon.hashCode();
        result = 31 * result + this.number;
        return result;
    }

    public boolean equals(Object obj) {
        DaemonErrorNumber other;
        if (obj == null) {
            return false;
        }
        return obj instanceof DaemonErrorNumber && this.number == (other = (DaemonErrorNumber)obj).get() && this.daemon.equals(other.daemon());
    }

    public String toString() {
        return "ADaemonErrorNumber{number=" + this.number + ", daemon='" + this.daemon + '\'' + '}';
    }
}

