/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model.ivo.util;

import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.util.ConvertingUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.DateTime;

public class GenericConverter {
    public static <Destination, Origin> Destination convert(Origin origin, Class<Destination> destinationClass) {
        Destination result = GenericConverter.createInstance(destinationClass);
        result = GenericConverter.copy(origin, result);
        return result;
    }

    private static <Destination, Origin> Destination copy(Origin origin, Destination result) {
        HashMap<Field, Field> map = GenericConverter.resolveFieldMapFromOrigin(origin, result);
        for (Field originField : map.keySet()) {
            originField.setAccessible(true);
            Field destinationField = map.get(originField);
            if (destinationField == null) continue;
            GenericConverter.copyValue(origin, result, originField, destinationField);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <Destination, Origin> void copyValue(Origin origin, Destination result, Field originField, Field destinationField) {
        try {
            Object originalValue = GenericConverter.extractValue(origin, originField);
            if (originalValue == null) {
                destinationField.set(result, null);
                return;
            } else {
                if (originalValue instanceof Collection) {
                    Class<String> class1 = null;
                    for (Object object : (Collection)originalValue) {
                        class1 = object.getClass();
                    }
                    if (class1 != null && !class1.isAssignableFrom(String.class)) return;
                }
                if (originalValue instanceof IVO) {
                    destinationField.set(result, GenericConverter.convert(originalValue, destinationField.getType()));
                    return;
                } else if (originalValue instanceof BigDecimal && String.class.isAssignableFrom(destinationField.getType())) {
                    destinationField.set(result, ConvertingUtils.convertBigDecimalToString((BigDecimal)originalValue));
                    return;
                } else if (originalValue instanceof String && BigDecimal.class.isAssignableFrom(destinationField.getType())) {
                    destinationField.set(result, ConvertingUtils.convertStringToBigDecimal((String)originalValue));
                    return;
                } else if (originalValue instanceof Date && DateTime.class.isAssignableFrom(destinationField.getType())) {
                    destinationField.set(result, new DateTime(originalValue));
                    return;
                } else if (originalValue instanceof DateTime && Date.class.isAssignableFrom(destinationField.getType())) {
                    destinationField.set(result, new DateTime(originalValue).toDate());
                    return;
                } else {
                    destinationField.set(result, originalValue);
                }
            }
            return;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static Object extractValue(Object object, Field field) throws IllegalAccessException {
        Object value = null;
        try {
            Method getter = GenericConverter.getGetter(object.getClass(), field.getName());
            getter.setAccessible(true);
            value = getter.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            field.setAccessible(true);
            value = field.get(object);
        }
        return value;
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private static Method getGetter(Class<?> clazz, String fieldname) throws NoSuchMethodException {
        Method m = null;
        try {
            m = clazz.getMethod("get" + GenericConverter.capitalize(fieldname), new Class[0]);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return m;
    }

    private static <Destination, Origin> HashMap<Field, Field> resolveFieldMapFromOrigin(Origin origin, Destination destination) {
        HashMap<String, Field> createFieldMap = GenericConverter.createFieldMap(origin);
        HashMap<String, Field> createFieldMap2 = GenericConverter.createFieldMap(destination);
        HashMap<Field, Field> result = new HashMap<Field, Field>();
        for (Field field : createFieldMap.values()) {
            if (createFieldMap2.containsKey(field.getName())) {
                result.put(field, createFieldMap2.get(field.getName()));
            }
            if (field.getName().equals("version")) {
                result.put(field, createFieldMap2.get("_version"));
            }
            if (field.getName().equals("_version")) {
                result.put(field, createFieldMap2.get("version"));
            }
            if (field.getName().equals("lastChange")) {
                result.put(field, createFieldMap2.get("_lastChange"));
            }
            if (field.getName().equals("_lastChange")) {
                result.put(field, createFieldMap2.get("lastChange"));
            }
            if (field.getName().equals("lastChangeUserId")) {
                result.put(field, createFieldMap2.get("_lastChangeUserId"));
            }
            if (!field.getName().equals("_lastChangeUserId")) continue;
            result.put(field, createFieldMap2.get("lastChangeUserId"));
        }
        return result;
    }

    private static <Destination> Destination createInstance(Class<Destination> destinationClass) {
        Destination result = null;
        try {
            result = destinationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        return result;
    }

    private static HashMap<String, Field> createFieldMap(Object element) {
        HashMap<String, Field> result = new HashMap<String, Field>();
        Class<?> obj = element.getClass();
        while (!obj.equals(Object.class)) {
            for (Field field : obj.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                result.put(field.getName(), field);
            }
            obj = obj.getSuperclass();
        }
        return result;
    }
}

