/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model;

import de.taimos.dvalin.interconnect.model.CryptoException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Scanner;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public final class MessageCryptoUtil {
    public static final String SIGNATURE_HEADER = "Signature";
    private static final String AES_KEY = System.getProperty("interconnect.crypto.aes");
    private static final String SIGNATURE = System.getProperty("interconnect.crypto.signature");

    private MessageCryptoUtil() {
    }

    public static String crypt(String data) throws CryptoException {
        if (data == null) {
            return null;
        }
        try {
            Cipher cipher = MessageCryptoUtil.getCipher(1);
            byte[] encrypted = cipher.doFinal(data.getBytes());
            return new String(Base64.encodeBase64String((byte[])encrypted));
        }
        catch (Exception e) {
            throw new CryptoException("Encryption of data failed!", e);
        }
    }

    public static String decrypt(String data) throws CryptoException {
        if (data == null) {
            return null;
        }
        try {
            Cipher cipher = MessageCryptoUtil.getCipher(2);
            return new String(cipher.doFinal(Base64.decodeBase64((String)data)));
        }
        catch (Exception e) {
            throw new CryptoException("Decryption of data failed!", e);
        }
    }

    private static Cipher getCipher(int mode) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(Hex.decodeHex((char[])AES_KEY.toCharArray()), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(mode, skeySpec);
        return cipher;
    }

    public static String sign(String msg) throws CryptoException {
        try {
            String toEnc = msg + SIGNATURE;
            MessageDigest mdEnc = MessageDigest.getInstance("MD5");
            mdEnc.update(toEnc.getBytes(), 0, toEnc.length());
            return new BigInteger(1, mdEnc.digest()).toString(16);
        }
        catch (Exception e) {
            throw new CryptoException("Creating signature failed", e);
        }
    }

    public static boolean validate(String msg, String signature) throws CryptoException {
        if (signature == null || signature.isEmpty()) {
            return false;
        }
        String calcSig = MessageCryptoUtil.sign(msg);
        return calcSig.equals(signature);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Select (k=generate key; c=crypt; d=decrypt):");
            System.out.println();
            Scanner scan = new Scanner(System.in);
            if (!scan.hasNextLine()) {
                return;
            }
            switch (scan.nextLine()) {
                case "k": {
                    MessageCryptoUtil.generateKey();
                    break;
                }
                case "c": {
                    System.out.print("Input data: ");
                    String data = scan.nextLine();
                    System.out.println(MessageCryptoUtil.crypt(data));
                    break;
                }
                case "d": {
                    System.out.print("Input data: ");
                    String ddata = scan.nextLine();
                    System.out.println(MessageCryptoUtil.decrypt(ddata));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void generateKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128);
            SecretKey skey = kgen.generateKey();
            System.out.println("Key: " + Hex.encodeHexString((byte[])skey.getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

