/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import de.taimos.dvalin.interconnect.model.DateTimeDeserializerWithTZ;
import de.taimos.dvalin.interconnect.model.DateTimeKeyDeserializer;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import java.io.IOException;
import org.joda.time.DateTime;

public final class InterconnectMapper {
    private static ObjectMapper mapper = InterconnectMapper.createMapper();

    private InterconnectMapper() {
    }

    public static InterconnectObject fromJson(String data) throws JsonParseException, JsonMappingException, IOException {
        return InterconnectMapper.fromJson(data, InterconnectObject.class);
    }

    public static <T extends InterconnectObject> T fromJson(String data, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)((InterconnectObject)mapper.readValue(data, clazz));
    }

    public static String toJson(InterconnectObject object) throws JsonGenerationException, JsonMappingException, IOException {
        return mapper.writeValueAsString((Object)object);
    }

    private static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        JodaModule jm = new JodaModule();
        jm.addKeyDeserializer(DateTime.class, (KeyDeserializer)new DateTimeKeyDeserializer());
        jm.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializerWithTZ());
        mapper.registerModule((Module)jm);
        mapper.registerModule((Module)new GuavaModule());
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        return mapper;
    }
}

