/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model;

import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import java.util.UUID;

public class InterconnectContext {
    private static final ThreadLocal<InnerContext> threadLocalContext = new ThreadLocal();

    private static InnerContext getThreadLocalContext() {
        if (threadLocalContext.get() == null) {
            threadLocalContext.set(new InnerContext());
        }
        return threadLocalContext.get();
    }

    public static Class<? extends IVO> getRequestClass() {
        return InterconnectContext.getThreadLocalContext().requestClass();
    }

    public static UUID getUuid() {
        return InterconnectContext.getThreadLocalContext().uuid();
    }

    public static int getDeliveryCount() {
        return InterconnectContext.getThreadLocalContext().deliveryCount();
    }

    public static boolean isRedelivered() {
        return InterconnectContext.getThreadLocalContext().redelivered();
    }

    public static void setRequestClass(Class<? extends IVO> requestClass) {
        InterconnectContext.getThreadLocalContext().setRequestClass(requestClass);
    }

    public static void setUuid(UUID uuid) {
        InterconnectContext.getThreadLocalContext().setUuid(uuid);
    }

    public static void setDeliveryCount(int deliveryCount) {
        InterconnectContext.getThreadLocalContext().setDeliveryCount(deliveryCount);
    }

    public static void setRedelivered(boolean redelivered) {
        InterconnectContext.getThreadLocalContext().setRedelivered(redelivered);
    }

    public static void reset() {
        threadLocalContext.remove();
    }

    public static IDaemonHandler.IContext getContext() {
        return InterconnectContext.getThreadLocalContext();
    }

    private static class InnerContext
    implements IDaemonHandler.IContext {
        private Class<? extends IVO> requestClass;
        private UUID uuid = UUID.randomUUID();
        private int deliveryCount = 1;
        private boolean redelivered;

        private InnerContext() {
        }

        @Override
        public Class<? extends IVO> requestClass() {
            return this.requestClass;
        }

        public void setRequestClass(Class<? extends IVO> requestClass) {
            this.requestClass = requestClass;
        }

        @Override
        public UUID uuid() {
            return this.uuid;
        }

        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public int deliveryCount() {
            return this.deliveryCount;
        }

        public void setDeliveryCount(int deliveryCount) {
            this.deliveryCount = deliveryCount;
        }

        @Override
        public boolean redelivered() {
            return this.redelivered;
        }

        public void setRedelivered(boolean redelivered) {
            this.redelivered = redelivered;
        }
    }
}

