/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model;

import java.util.EventListener;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class FutureImpl<T>
implements Future<T> {
    private static final Object CANCELLED_FLAG = new Object();
    private final UUID id = UUID.randomUUID();
    private final CountDownLatch cdl = new CountDownLatch(1);
    private final AtomicReference<Object> value = new AtomicReference<Object>(null);
    private final Set<CancelListener<T>> listeners = new CopyOnWriteArraySet<CancelListener<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.value.compareAndSet(null, CANCELLED_FLAG)) {
            try {
                for (CancelListener<T> listener : this.listeners) {
                    listener.wasCancelled(this.getId());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.listeners.clear();
                this.cdl.countDown();
            }
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return CANCELLED_FLAG.equals(this.value.get());
    }

    @Override
    public boolean isDone() {
        return this.cdl.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException, CancellationException {
        this.cdl.await();
        Object o = this.value.get();
        if (CANCELLED_FLAG.equals(o)) {
            throw new CancellationException();
        }
        if (o instanceof Exception) {
            throw new ExecutionException((Exception)o);
        }
        return (T)o;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException, CancellationException {
        if (!this.cdl.await(timeout, unit)) {
            throw new TimeoutException();
        }
        Object o = this.value.get();
        if (CANCELLED_FLAG.equals(o)) {
            throw new CancellationException();
        }
        if (o instanceof Exception) {
            throw new ExecutionException((Exception)o);
        }
        return (T)o;
    }

    @Deprecated
    public void setResult(T value) {
        this.set(value);
    }

    public void set(T value) {
        if (this.value.compareAndSet(null, value)) {
            this.listeners.clear();
            this.cdl.countDown();
        }
    }

    public void set(Exception e) {
        if (this.value.compareAndSet(null, e)) {
            this.listeners.clear();
            this.cdl.countDown();
        }
    }

    public UUID getId() {
        return this.id;
    }

    public void addCancelListener(CancelListener<T> listener) {
        Object v = this.value.get();
        if (v == null) {
            this.listeners.add(listener);
        } else if (CANCELLED_FLAG.equals(v)) {
            listener.wasCancelled(this.getId());
        }
    }

    public void removeCancelListener(CancelListener<T> listener) {
        if (this.value.get() == null) {
            this.listeners.remove(listener);
        }
    }

    public static interface CancelListener<T>
    extends EventListener {
        public void wasCancelled(UUID var1);
    }
}

