/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimeDeserializerWithTZ
extends StdScalarDeserializer<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateTimeDeserializerWithTZ() {
        super(DateTime.class);
    }

    public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new DateTime(jp.getLongValue(), DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone()));
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            if (str.charAt(str.length() - 6) == '+' || str.charAt(str.length() - 1) == 'Z' || str.charAt(str.length() - 6) == '-') {
                return new DateTime((Object)str);
            }
            return new DateTime((Object)str, DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone()));
        }
        ctxt.handleUnexpectedToken(this.handledType(), jp);
        return null;
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }
}

