/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import de.taimos.dvalin.interconnect.core.MessageConnector;
import de.taimos.dvalin.interconnect.core.spring.DaemonMessageSenderHeader;
import de.taimos.dvalin.interconnect.core.spring.IDaemonEventListener;
import de.taimos.dvalin.interconnect.core.spring.IDaemonEvents;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.model.InterconnectMapper;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public final class DaemonEvents
implements IDaemonEvents,
MessageListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<Class<? extends IVO>, CopyOnWriteArraySet<IDaemonEventListener>> listeners = new ConcurrentHashMap();
    private final Executor executor = Executors.newCachedThreadPool();
    @Autowired
    private IDaemonMessageSender messageSender;
    private DefaultMessageListenerContainer container;
    @Autowired(required=false)
    private ConnectionFactory jmsFactory;
    private final ConcurrentHashMap<String, DateTime> eventErrors = new ConcurrentHashMap();

    public void start() {
        this.container = new DefaultMessageListenerContainer();
        this.container.setPubSubDomain(true);
        this.container.setConnectionFactory(this.jmsFactory);
        this.container.setDestinationName("events.global");
        this.container.setMessageListener((Object)this);
        this.container.setSessionAcknowledgeMode(1);
        this.container.setConcurrentConsumers(1);
        this.container.initialize();
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    void emit(final IVO event) {
        if (this.listeners.containsKey(event.getClass())) {
            CopyOnWriteArraySet<IDaemonEventListener> l = this.listeners.get(event.getClass());
            if (l.size() != 0) {
                this.logger.info("Event " + event.getClass().getSimpleName());
            }
            for (final IDaemonEventListener listener : l) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onEvent(event);
                    }
                });
            }
        }
    }

    @Override
    public <I extends IVO> void listen(Class<I> eventIVOClazz, IDaemonEventListener<I> listener) {
        this.listeners.putIfAbsent(eventIVOClazz, new CopyOnWriteArraySet());
        this.listeners.get(eventIVOClazz).add(listener);
    }

    @Override
    public <I extends IVO> void unlisten(Class<I> eventIVOClazz, IDaemonEventListener<I> listener) {
        if (this.listeners.containsKey(eventIVOClazz)) {
            this.listeners.get(eventIVOClazz).remove(listener);
        }
    }

    private static final String icoClassToSaveString(String icoClass) {
        if (icoClass == null) {
            return "nullclass";
        }
        return "class:" + icoClass;
    }

    void logEventError(String icoClass, String message, Throwable throwable) {
        String saveIcoClass = DaemonEvents.icoClassToSaveString(icoClass);
        DateTime lastSeen = this.eventErrors.get(saveIcoClass);
        DateTime now = new DateTime();
        DateTime treshold = now.minusMinutes(30);
        if (lastSeen == null || lastSeen.isBefore((ReadableInstant)treshold)) {
            if (lastSeen == null) {
                this.eventErrors.putIfAbsent(saveIcoClass, now);
            } else {
                this.eventErrors.replace(saveIcoClass, lastSeen, now);
            }
            this.logger.error(message, throwable);
        }
    }

    public void onMessage(Message message) {
        block10: {
            String icoClass;
            try {
                icoClass = message.getStringProperty("InterconnectICOClass");
            }
            catch (Exception e) {
                this.logger.error("Exception", (Throwable)e);
                return;
            }
            try {
                if (message instanceof TextMessage) {
                    InterconnectObject ico;
                    TextMessage textMessage = (TextMessage)message;
                    this.logger.debug("TextMessage received: {}", (Object)textMessage.getText());
                    if (MessageConnector.isMessageSecure(textMessage)) {
                        MessageConnector.decryptMessage(textMessage);
                    }
                    try {
                        ico = InterconnectMapper.fromJson((String)textMessage.getText());
                    }
                    catch (Exception e) {
                        this.logEventError(icoClass, "Event not supported", e);
                        return;
                    }
                    if (ico instanceof IVO) {
                        this.emit((IVO)ico);
                    } else {
                        this.logEventError(icoClass, "Event not an IVO", null);
                    }
                    break block10;
                }
                this.logEventError(icoClass, "Event not a TextMessage", null);
            }
            catch (Exception e) {
                this.logEventError(icoClass, "Exception", e);
            }
        }
    }

    @Override
    public void publish(IVO event) {
        this.logger.debug("Publish " + event.getClass().getSimpleName());
        try {
            this.messageSender.sendToTopic("events.global", (InterconnectObject)event, false, new DaemonMessageSenderHeader[0]);
        }
        catch (Exception e) {
            this.logger.error("Can not publish event", (Throwable)e);
        }
    }
}

