/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.daemon;

import de.taimos.dvalin.interconnect.core.InterconnectConnector;
import de.taimos.dvalin.interconnect.core.daemon.IDaemonRequestResponse;
import de.taimos.dvalin.interconnect.model.FutureImpl;
import de.taimos.dvalin.interconnect.model.InterconnectList;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.ivo.daemon.DaemonErrorIVO;
import de.taimos.dvalin.interconnect.model.service.ADaemonErrorNumber;
import de.taimos.dvalin.interconnect.model.service.DaemonError;
import de.taimos.dvalin.interconnect.model.service.DaemonErrorNumber;
import de.taimos.dvalin.interconnect.model.service.DaemonScanner;
import java.lang.reflect.Array;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;

public final class DaemonRequestResponse
implements IDaemonRequestResponse {
    private static final long DEFAULT_TIMEOUT = 10L;
    private static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final Executor executor = Executors.newCachedThreadPool();

    private static <R> R toResponse(InterconnectObject ico, Class<R> responseClazz) throws DataFormatException, DaemonError {
        if (ico instanceof DaemonErrorIVO) {
            DaemonErrorIVO de = (DaemonErrorIVO)ico;
            GenericError den = new GenericError(de.getNumber(), de.getDaemon());
            throw new DaemonError((DaemonErrorNumber)den, ((DaemonErrorIVO)ico).getMessage());
        }
        if (responseClazz.isArray() && ico instanceof InterconnectList) {
            InterconnectList list = (InterconnectList)ico;
            Object obj = Array.newInstance(responseClazz.getComponentType(), list.getElements().size());
            return (R)list.getElements().toArray(DaemonScanner.object2Array(responseClazz.getComponentType(), (Object)obj));
        }
        if (ico instanceof InterconnectList && List.class.isAssignableFrom(responseClazz)) {
            InterconnectList list = (InterconnectList)ico;
            return (R)list.getElements();
        }
        if (responseClazz.isAssignableFrom(ico.getClass())) {
            return (R)ico;
        }
        throw new DataFormatException("Response was not of type " + responseClazz.getSimpleName());
    }

    @Override
    public <R> R sync(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz) throws ExecutionException {
        return this.sync(uuid, queue, request, responseClazz, 10L, DEFAULT_TIMEOUT_UNIT);
    }

    @Override
    public <R> R sync(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz, long timeout, TimeUnit unit) throws ExecutionException {
        return this.sync(uuid, queue, request, responseClazz, timeout, unit, false);
    }

    @Override
    public <R> R sync(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz, long timeout, TimeUnit unit, boolean secure) throws ExecutionException {
        try {
            InterconnectObject response = InterconnectConnector.request(uuid, queue, request, null, secure, TimeUnit.MILLISECONDS.convert(timeout, unit), TimeUnit.MILLISECONDS.convert(timeout, unit), 5);
            return DaemonRequestResponse.toResponse(response, responseClazz);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public <R> Future<R> async(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz) {
        return this.async(uuid, queue, request, responseClazz, 10L, DEFAULT_TIMEOUT_UNIT);
    }

    @Override
    public <R> Future<R> async(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz, long timeout, TimeUnit unit) {
        return this.async(uuid, queue, request, responseClazz, timeout, unit, false);
    }

    @Override
    public <R> Future<R> async(final UUID uuid, final String queue, final InterconnectObject request, final Class<R> responseClazz, final long timeout, final TimeUnit unit, final boolean secure) {
        final FutureImpl f = new FutureImpl();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InterconnectObject response = InterconnectConnector.request(uuid, queue, request, null, secure, TimeUnit.MILLISECONDS.convert(timeout, unit), TimeUnit.MILLISECONDS.convert(timeout, unit), 5);
                    f.set(DaemonRequestResponse.toResponse(response, responseClazz));
                }
                catch (Exception e) {
                    f.set(e);
                }
            }
        });
        return f;
    }

    private static final class GenericError
    extends ADaemonErrorNumber {
        private static final long serialVersionUID = 1L;

        public GenericError(int aNumber, String aDaemon) {
            super(aNumber, aDaemon);
        }
    }
}

