/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.config;

import de.taimos.dvalin.interconnect.core.daemon.DaemonRequestResponse;
import de.taimos.dvalin.interconnect.core.daemon.IDaemonRequestResponse;
import de.taimos.dvalin.interconnect.core.spring.DaemonMessageListener;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.ErrorHandler;

@Configuration
@Profile(value={"prod"})
@EnableTransactionManagement
public class JMSConfig {
    @Value(value="${interconnect.jms.broker}")
    private String brokerUrl;
    @Value(value="${interconnect.jms.consumers:2-8}")
    private String consumers;
    @Value(value="${serviceName}")
    private String serviceName;

    @Bean
    public ConnectionFactory jmsConnectionFactory() {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(this.brokerUrl);
        return factory;
    }

    @Bean(destroyMethod="stop")
    public PooledConnectionFactory jmsFactory(ConnectionFactory jmsConnectionFactory) {
        PooledConnectionFactory pool = new PooledConnectionFactory();
        pool.setConnectionFactory(jmsConnectionFactory);
        pool.setCreateConnectionOnStartup(true);
        pool.setIdleTimeout(0);
        pool.setMaxConnections(3);
        pool.setMaximumActiveSessionPerConnection(100);
        pool.setBlockIfSessionPoolIsFull(false);
        return pool;
    }

    @Bean
    public JmsTemplate jmsTemplate(PooledConnectionFactory jmsFactory) {
        return new JmsTemplate((ConnectionFactory)jmsFactory);
    }

    @Bean
    public JmsTemplate topicJmsTemplate(PooledConnectionFactory jmsFactory) {
        JmsTemplate template = new JmsTemplate((ConnectionFactory)jmsFactory);
        template.setPubSubDomain(true);
        return template;
    }

    @Bean
    @Scope(value="singleton")
    public IDaemonRequestResponse requestResponse() {
        return new DaemonRequestResponse();
    }

    @Bean
    public DefaultMessageListenerContainer jmsListenerContainer(PooledConnectionFactory jmsFactory, DaemonMessageListener messageListener) {
        DefaultMessageListenerContainer dmlc = new DefaultMessageListenerContainer();
        dmlc.setConnectionFactory((ConnectionFactory)jmsFactory);
        dmlc.setErrorHandler((ErrorHandler)messageListener);
        dmlc.setConcurrency(this.consumers);
        dmlc.setDestination((Destination)new ActiveMQQueue(this.serviceName + ".request"));
        dmlc.setMessageListener((Object)messageListener);
        return dmlc;
    }
}

