/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.spring;

import de.taimos.daemon.ILoggingConfigurer;
import de.taimos.daemon.spring.SpringTest;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;

public class SpringDaemonTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(SpringDaemonTestRunner.class);
    private SpringTest springTest;

    public SpringDaemonTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        final Statement invoker = super.methodInvoker(method, test);
        return new Statement(){

            public void evaluate() throws Throwable {
                invoker.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement next = super.withAfterClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                next.evaluate();
                SpringDaemonTestRunner.this.springTest.stop();
            }
        };
    }

    protected Statement withBeforeClasses(Statement statement) {
        final Statement next = super.withBeforeClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                final RunnerConfiguration cfgClass = this.findConfigAnnotation(SpringDaemonTestRunner.this.getTestClass().getJavaClass());
                if (cfgClass == null) {
                    throw new RuntimeException("Missing @RunnerConfiguration");
                }
                ILoggingConfigurer lc = cfgClass.loggingConfigurer().newInstance();
                lc.simpleLogging();
                final RunnerConfig cfg = cfgClass.config().newInstance();
                cfg.addProperty("serviceName", cfgClass.svc());
                cfg.addProperty("profiles", "test");
                cfg.addProperty("startupMode", "dev");
                try {
                    SpringDaemonTestRunner.this.springTest = new SpringTest(){

                        @Override
                        protected String getServiceName() {
                            return cfgClass.svc();
                        }

                        @Override
                        protected void fillProperties(Map<String, String> props) {
                            String servicePackage = cfg.getServicePackage();
                            if (servicePackage != null) {
                                props.put("servicePackage", servicePackage);
                                System.setProperty("servicePackage", servicePackage);
                            }
                            Enumeration<?> names = cfg.getProps().propertyNames();
                            while (names.hasMoreElements()) {
                                String key = (String)names.nextElement();
                                props.put(key, cfg.getProps().getProperty(key));
                            }
                        }

                        @Override
                        protected String getSpringResource() {
                            return cfg.getSpringFile();
                        }

                        @Override
                        protected void doAfterSpringStart() {
                            List methods = this.findAfterStartupAnnotatedMethods(SpringDaemonTestRunner.this.getTestClass().getJavaClass());
                            for (Method method : methods) {
                                try {
                                    method.invoke(SpringDaemonTestRunner.this.createTest(), new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Starting Spring context failed", e);
                                }
                            }
                        }
                    };
                    SpringDaemonTestRunner.this.springTest.start();
                    next.evaluate();
                }
                catch (IllegalStateException | BeansException e) {
                    logger.error("Starting Spring context failed", e);
                    throw new RuntimeException("Starting Spring context failed", e);
                }
            }

            private RunnerConfiguration findConfigAnnotation(Class<?> clazz) {
                if (clazz == null) {
                    return null;
                }
                RunnerConfiguration cfgClass = clazz.getAnnotation(RunnerConfiguration.class);
                if (cfgClass == null) {
                    cfgClass = this.findConfigAnnotation(clazz.getSuperclass());
                }
                return cfgClass;
            }

            private List<Method> findAfterStartupAnnotatedMethods(Class<?> clazz) {
                Method[] methods;
                ArrayList<Method> res = new ArrayList<Method>();
                if (clazz == null) {
                    return res;
                }
                for (Method method : methods = clazz.getMethods()) {
                    if (!method.isAnnotationPresent(AfterStartup.class) || method.getParameterTypes().length != 0) continue;
                    res.add(method);
                }
                return res;
            }
        };
    }

    protected Object createTest() throws Exception {
        return this.springTest.getContext().getBeanFactory().createBean(this.getTestClass().getJavaClass());
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AfterStartup {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RunnerConfiguration {
        public Class<? extends RunnerConfig> config() default RunnerConfig.class;

        public String svc();

        public Class<? extends ILoggingConfigurer> loggingConfigurer();
    }

    public static class RunnerConfig {
        private final Properties props = new Properties();

        protected void addProperty(String key, String value) {
            this.props.setProperty(key.trim(), value);
        }

        public Properties getProps() {
            return this.props;
        }

        public String getSpringFile() {
            return "spring-test/beans.xml";
        }

        public String getServicePackage() {
            return null;
        }

        protected static Integer randomPort() {
            return (int)(Math.random() * 20000.0 + 10000.0);
        }
    }
}

