/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.log4j;

import de.taimos.daemon.DaemonStarter;
import de.taimos.daemon.ILoggingConfigurer;
import de.taimos.daemon.log4j.JSONLayout;
import de.taimos.daemon.log4j.LogentriesAppender;
import de.taimos.daemon.log4j.LogglyAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;

public class Log4jLoggingConfigurer
implements ILoggingConfigurer {
    private final Logger rlog = Logger.getRootLogger();
    private SyslogAppender syslog;
    private DailyRollingFileAppender darofi;
    private LogglyAppender loggly;
    private LogentriesAppender logentries;
    private ConsoleAppender console;

    public void initializeLogging() throws Exception {
        this.rlog.removeAllAppenders();
        this.rlog.setLevel(Level.INFO);
        if (!DaemonStarter.isDevelopmentMode()) {
            this.darofi = new DailyRollingFileAppender();
            this.darofi.setName("DAROFI");
            this.darofi.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
            this.darofi.setFile("log/" + DaemonStarter.getDaemonName() + ".log");
            this.darofi.setDatePattern("'.'yyyy-MM-dd");
            this.darofi.setAppend(true);
            this.darofi.setThreshold((Priority)Level.INFO);
            this.darofi.activateOptions();
            this.rlog.addAppender((Appender)this.darofi);
            this.syslog = new SyslogAppender();
            this.syslog.setName("SYSLOG");
            this.syslog.setLayout((Layout)new PatternLayout(DaemonStarter.getDaemonName() + ": %-5p %c %x - %m%n"));
            this.syslog.setSyslogHost("localhost");
            this.syslog.setFacility("LOCAL0");
            this.syslog.setFacilityPrinting(false);
            this.syslog.setThreshold((Priority)Level.INFO);
            this.syslog.activateOptions();
            this.rlog.addAppender((Appender)this.syslog);
        }
        if (DaemonStarter.isDevelopmentMode() || DaemonStarter.isRunMode()) {
            this.console = new ConsoleAppender();
            this.console.setName("CONSOLE");
            this.console.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
            this.console.setTarget("System.out");
            this.console.activateOptions();
            this.rlog.addAppender((Appender)this.console);
        }
    }

    public void reconfigureLogging() throws Exception {
        Level logLevel = Level.toLevel((String)DaemonStarter.getDaemonProperties().getProperty("logger.level"), (Level)Level.INFO);
        String logPattern = System.getProperty("logger.pattern", "%d{HH:mm:ss,SSS} %-5p %c %x - %m%n");
        this.rlog.setLevel(logLevel);
        this.rlog.info((Object)String.format("Changed the the log level to %s", logLevel));
        if (!DaemonStarter.isDevelopmentMode()) {
            String token;
            String fileEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.file", "true");
            String syslogEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.syslog", "true");
            String logglyEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.loggly", "false");
            String logentriesEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.logentries", "false");
            if (fileEnabled != null && fileEnabled.equals("false")) {
                this.rlog.removeAppender((Appender)this.darofi);
                this.darofi = null;
                this.rlog.info((Object)String.format("Deactivated the FILE Appender", new Object[0]));
            } else {
                this.darofi.setThreshold((Priority)logLevel);
                this.darofi.setLayout((Layout)new PatternLayout(logPattern));
                this.darofi.activateOptions();
            }
            if (syslogEnabled != null && syslogEnabled.equals("false")) {
                this.rlog.removeAppender((Appender)this.syslog);
                this.syslog = null;
                this.rlog.info((Object)String.format("Deactivated the SYSLOG Appender", new Object[0]));
            } else {
                String host = DaemonStarter.getDaemonProperties().getProperty("syslog.host", "localhost");
                String facility = DaemonStarter.getDaemonProperties().getProperty("syslog.facility", "LOCAL0");
                Level syslogLevel = Level.toLevel((String)DaemonStarter.getDaemonProperties().getProperty("syslog.level"), (Level)Level.INFO);
                this.syslog.setSyslogHost(host);
                this.syslog.setFacility(facility);
                this.syslog.setThreshold((Priority)syslogLevel);
                this.syslog.activateOptions();
                this.rlog.info((Object)String.format("Changed the SYSLOG Appender to host %s and facility %s", host, facility));
            }
            if (logglyEnabled != null && logglyEnabled.equals("false")) {
                this.loggly = null;
                this.rlog.info((Object)String.format("Deactivated the LOGGLY Appender", new Object[0]));
            } else {
                token = DaemonStarter.getDaemonProperties().getProperty("loggly.token");
                if (token == null || token.isEmpty()) {
                    this.rlog.error((Object)"Missing loggly token but loggly is activated");
                } else {
                    String tags = DaemonStarter.getDaemonProperties().getProperty("loggly.tags");
                    this.loggly = new LogglyAppender();
                    this.loggly.setToken(token);
                    this.loggly.setTags(tags);
                    this.loggly.setLayout(new JSONLayout());
                    this.loggly.activateOptions();
                    this.rlog.addAppender((Appender)this.loggly);
                }
            }
            if (logentriesEnabled != null && logentriesEnabled.equals("false")) {
                this.logentries = null;
                this.rlog.info((Object)String.format("Deactivated the LOGENTRIES Appender", new Object[0]));
            } else {
                token = DaemonStarter.getDaemonProperties().getProperty("logentries.token");
                if (token == null || token.isEmpty()) {
                    this.rlog.error((Object)"Missing logentries token but logentries is activated");
                } else {
                    this.logentries = new LogentriesAppender();
                    this.logentries.setToken(token);
                    this.logentries.setLayout(new JSONLayout());
                    this.logentries.activateOptions();
                    this.rlog.addAppender((Appender)this.logentries);
                }
            }
        }
        if (DaemonStarter.isDevelopmentMode() || DaemonStarter.isRunMode()) {
            this.console.setLayout((Layout)new PatternLayout(logPattern));
            this.console.setThreshold((Priority)logLevel);
            this.console.activateOptions();
        }
    }

    public void simpleLogging() throws Exception {
        this.rlog.removeAllAppenders();
        this.rlog.setLevel(Level.INFO);
        this.console = new ConsoleAppender();
        this.console.setName("CONSOLE");
        this.console.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
        this.console.setTarget("System.out");
        this.console.activateOptions();
        this.rlog.addAppender((Appender)this.console);
    }

    public static void setup() {
        System.setProperty("loggerConfigurer", Log4jLoggingConfigurer.class.getCanonicalName());
    }
}

