/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.log4j;

import com.sumologic.log4j.SumoLogicAppender;
import de.taimos.daemon.DaemonStarter;
import de.taimos.daemon.ILoggingConfigurer;
import de.taimos.daemon.log4j.JSONLayout;
import de.taimos.daemon.log4j.LogentriesAppender;
import de.taimos.daemon.log4j.LogglyAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;

public class Log4jLoggingConfigurer
implements ILoggingConfigurer {
    private final Logger rlog = Logger.getRootLogger();
    private SyslogAppender syslog;
    private DailyRollingFileAppender darofi;
    private ConsoleAppender console;

    public void initializeLogging() throws Exception {
        this.rlog.removeAllAppenders();
        this.rlog.setLevel(Level.INFO);
        if (!DaemonStarter.isDevelopmentMode()) {
            this.darofi = new DailyRollingFileAppender();
            this.darofi.setName("DAROFI");
            this.darofi.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
            this.darofi.setFile("log/" + DaemonStarter.getDaemonName() + ".log");
            this.darofi.setDatePattern("'.'yyyy-MM-dd");
            this.darofi.setAppend(true);
            this.darofi.setThreshold((Priority)Level.INFO);
            this.darofi.activateOptions();
            this.rlog.addAppender((Appender)this.darofi);
            this.syslog = new SyslogAppender();
            this.syslog.setName("SYSLOG");
            this.syslog.setLayout((Layout)new PatternLayout(DaemonStarter.getDaemonName() + ": %-5p %c %x - %m%n"));
            this.syslog.setSyslogHost("localhost");
            this.syslog.setFacility("LOCAL0");
            this.syslog.setFacilityPrinting(false);
            this.syslog.setThreshold((Priority)Level.INFO);
            this.syslog.activateOptions();
            this.rlog.addAppender((Appender)this.syslog);
        }
        if (DaemonStarter.isDevelopmentMode() || DaemonStarter.isRunMode()) {
            this.console = new ConsoleAppender();
            this.console.setName("CONSOLE");
            this.console.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
            this.console.setTarget("System.out");
            this.console.activateOptions();
            this.rlog.addAppender((Appender)this.console);
        }
    }

    public void reconfigureLogging() throws Exception {
        Level logLevel = Level.toLevel((String)DaemonStarter.getDaemonProperties().getProperty("logger.level"), (Level)Level.INFO);
        this.rlog.setLevel(logLevel);
        this.rlog.info((Object)String.format("Changed the the log level to %s", logLevel));
        if (!DaemonStarter.isDevelopmentMode()) {
            String token;
            String fileEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.file", "true");
            String syslogEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.syslog", "true");
            String logglyEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.loggly", "false");
            String logentriesEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.logentries", "false");
            String sumologicEnabled = DaemonStarter.getDaemonProperties().getProperty("logger.sumologic", "false");
            if (fileEnabled != null && fileEnabled.equals("false")) {
                this.rlog.removeAppender((Appender)this.darofi);
                this.darofi = null;
                this.rlog.info((Object)"Deactivated the FILE Appender");
            } else {
                this.darofi.setThreshold((Priority)logLevel);
                this.darofi.setLayout(this.getLayout());
                this.darofi.activateOptions();
            }
            if (syslogEnabled != null && syslogEnabled.equals("false")) {
                this.rlog.removeAppender((Appender)this.syslog);
                this.syslog = null;
                this.rlog.info((Object)"Deactivated the SYSLOG Appender");
            } else {
                String host = DaemonStarter.getDaemonProperties().getProperty("syslog.host", "localhost");
                String facility = DaemonStarter.getDaemonProperties().getProperty("syslog.facility", "LOCAL0");
                Level syslogLevel = Level.toLevel((String)DaemonStarter.getDaemonProperties().getProperty("syslog.level"), (Level)Level.INFO);
                this.syslog.setSyslogHost(host);
                this.syslog.setFacility(facility);
                this.syslog.setThreshold((Priority)syslogLevel);
                this.syslog.activateOptions();
                this.rlog.info((Object)String.format("Changed the SYSLOG Appender to host %s and facility %s", host, facility));
            }
            if (logglyEnabled != null && logglyEnabled.equals("false")) {
                this.rlog.info((Object)"Deactivated the LOGGLY Appender");
            } else {
                token = DaemonStarter.getDaemonProperties().getProperty("loggly.token");
                if (token == null || token.isEmpty()) {
                    this.rlog.error((Object)"Missing loggly token but loggly is activated");
                } else {
                    String tags = DaemonStarter.getDaemonProperties().getProperty("loggly.tags");
                    LogglyAppender loggly = new LogglyAppender();
                    loggly.setToken(token);
                    loggly.setTags(tags);
                    loggly.setLayout(this.getLayout());
                    loggly.activateOptions();
                    this.rlog.addAppender((Appender)loggly);
                }
            }
            if (logentriesEnabled != null && logentriesEnabled.equals("false")) {
                this.rlog.info((Object)"Deactivated the LOGENTRIES Appender");
            } else {
                token = DaemonStarter.getDaemonProperties().getProperty("logentries.token");
                if (token == null || token.isEmpty()) {
                    this.rlog.error((Object)"Missing logentries token but logentries is activated");
                } else {
                    LogentriesAppender logentries = new LogentriesAppender();
                    logentries.setToken(token);
                    logentries.setLayout(this.getLayout());
                    logentries.activateOptions();
                    this.rlog.addAppender((Appender)logentries);
                }
            }
            if (sumologicEnabled != null && sumologicEnabled.equals("false")) {
                this.rlog.info((Object)"Deactivated the SUMOLOGIC Appender");
            } else {
                String url = DaemonStarter.getDaemonProperties().getProperty("sumologic.url");
                if (url == null || url.isEmpty()) {
                    this.rlog.error((Object)"Missing SumoLogic url but SumoLogic is activated");
                } else {
                    SumoLogicAppender sumoLogic = new SumoLogicAppender();
                    sumoLogic.setUrl(url);
                    sumoLogic.setLayout(this.getLayout());
                    sumoLogic.activateOptions();
                    this.rlog.addAppender((Appender)sumoLogic);
                }
            }
        }
        if (DaemonStarter.isDevelopmentMode() || DaemonStarter.isRunMode()) {
            this.console.setLayout(this.getLayout());
            this.console.setThreshold((Priority)logLevel);
            this.console.activateOptions();
        }
    }

    private Layout getLayout() {
        String logLayout;
        switch (logLayout = System.getProperty("logger.layout", "pattern")) {
            case "json": {
                return new JSONLayout();
            }
        }
        String logPattern = System.getProperty("logger.pattern", "%d{HH:mm:ss,SSS} %-5p %c %x - %m%n");
        return new PatternLayout(logPattern);
    }

    public void simpleLogging() throws Exception {
        this.rlog.removeAllAppenders();
        Level logLevel = Level.toLevel((String)System.getProperty("logger.level"), (Level)Level.INFO);
        this.rlog.setLevel(logLevel);
        this.console = new ConsoleAppender();
        this.console.setName("CONSOLE");
        this.console.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
        this.console.setTarget("System.out");
        this.console.activateOptions();
        this.rlog.addAppender((Appender)this.console);
    }

    public static void setup() {
        System.setProperty("loggerConfigurer", Log4jLoggingConfigurer.class.getCanonicalName());
    }
}

