/*
 * Decompiled with CFR 0.152.
 */
package de.starwit.auth.userdata;

import de.starwit.auth.userdata.ConfigData;
import de.starwit.auth.userdata.UserDirectoryDataRequester;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class UserDataFilter
implements Filter {
    final String ATTRIBUTE_NAME = "de.starwit.auth.userdata";
    private Logger log = Logger.getLogger(UserDataFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private DirContext getDirContext() {
        BasicConfigurator.configure();
        this.log.debug((Object)"UserDataFilter init");
        ConfigData configData = ConfigData.getInstance();
        String username = (String)configData.get("directory.username");
        String password = (String)configData.get("directory.password");
        String directoryUrl = (String)configData.get("directory.url");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", directoryUrl);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.principal", username);
        try {
            return new InitialDirContext(env);
        }
        catch (NamingException e) {
            this.log.error((Object)("Could not reach user directory " + directoryUrl + " with error " + e.getMessage() + " " + e.getExplanation()));
            return null;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.log.debug((Object)"UserDataFilter called, check if user data is already present on session");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession();
        Object data = session.getAttribute("de.starwit.auth.userdata");
        Map<Object, Object> userData = new HashMap<String, String>();
        if (data == null) {
            if (request.getUserPrincipal() != null) {
                DirContext ctx = this.getDirContext();
                String loggedInUser = request.getUserPrincipal().getName();
                if (ctx != null) {
                    UserDirectoryDataRequester dataRequester = new UserDirectoryDataRequester(ctx);
                    userData = dataRequester.getUserData(loggedInUser);
                }
                userData.put("alias", loggedInUser);
                session.setAttribute("de.starwit.auth.userdata", userData);
                if (userData.size() > 1) {
                    this.log.debug((Object)"loaded user data to session");
                } else {
                    this.log.warn((Object)("no data for user " + loggedInUser + " could be loaded from directory - empty data set on session"));
                }
            } else {
                this.log.warn((Object)"No logged in user found, please use UserDataFilter only on context paths with forced login.");
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
        this.log.debug((Object)"UserDataFilter destroyed");
    }
}

