/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.junit5;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import de.softwareforge.testing.postgres.junit5.AutoValue_PostgresVersionCondition_Version;
import de.softwareforge.testing.postgres.junit5.RequirePostgresVersion;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public final class PostgresVersionCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), RequirePostgresVersion.class).map(this::checkPostgresVersion).orElse(ConditionEvaluationResult.enabled((String)"No version annotation found"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConditionEvaluationResult checkPostgresVersion(RequirePostgresVersion requirePostgresVersion) {
        Version atLeastVersion = Version.valueOf(requirePostgresVersion.atLeast());
        Version lessThanVersion = Version.valueOf(requirePostgresVersion.lessThan());
        if (atLeastVersion.ignore() && lessThanVersion.ignore()) {
            return ConditionEvaluationResult.enabled((String)"No PostgreSQL version range set");
        }
        try (EmbeddedPostgres pg = EmbeddedPostgres.forVersionCheck();){
            Version postgresVersion = Version.valueOf(pg.getPostgresVersion());
            if (!atLeastVersion.ignore() && postgresVersion.compareTo(atLeastVersion) < 0) {
                ConditionEvaluationResult conditionEvaluationResult = ConditionEvaluationResult.disabled((String)String.format("Located PostgreSQL version is %s, at least version %s is required", postgresVersion, atLeastVersion));
                return conditionEvaluationResult;
            }
            if (!lessThanVersion.ignore() && lessThanVersion.compareTo(postgresVersion) < 0) {
                ConditionEvaluationResult conditionEvaluationResult = ConditionEvaluationResult.disabled((String)String.format("Located PostgreSQL version is %s, must be less than %s", postgresVersion, lessThanVersion));
                return conditionEvaluationResult;
            }
            ConditionEvaluationResult conditionEvaluationResult = ConditionEvaluationResult.enabled((String)String.format("Located PostgreSQL version is %s, version range is %s - %s", postgresVersion, atLeastVersion, lessThanVersion));
            return conditionEvaluationResult;
        }
        catch (IOException e) {
            return ConditionEvaluationResult.disabled((String)"IOException while checking postgres version", (String)e.getMessage());
        }
    }

    @AutoValue
    static abstract class Version
    implements Comparable<Version> {
        Version() {
        }

        abstract int major();

        abstract int minor();

        abstract int patch();

        private static Version valueOf(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            List values = Splitter.on((char)'.').trimResults().splitToList((CharSequence)value);
            return new AutoValue_PostgresVersionCondition_Version(Version.parseValue(values, 0), Version.parseValue(values, 1), Version.parseValue(values, 2));
        }

        private static int parseValue(List<String> values, int pos) {
            if (values.size() > pos && !values.get(pos).isEmpty()) {
                try {
                    return Integer.parseInt(values.get(pos));
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
            return 0;
        }

        private boolean ignore() {
            return this.major() == 0 && this.minor() == 0 && this.patch() == 0;
        }

        @Override
        public int compareTo(Version other) {
            return ComparisonChain.start().compare(this.major(), other.major()).compare(this.minor(), other.minor()).compare(this.patch(), other.patch()).result();
        }

        public String toString() {
            if (this.ignore()) {
                return "";
            }
            return Joiner.on((char)'.').join((Object)this.major(), (Object)this.minor(), new Object[]{this.patch()});
        }
    }
}

