/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.internal.impl;

import de.softwareforge.testing.maven.javax.inject.;
import de.softwareforge.testing.maven.org.eclipse.aether.$MultiRuntimeException;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$RepositorySystemLifecycle;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@.Singleton
@.Named
public class $DefaultRepositorySystemLifecycle
implements $RepositorySystemLifecycle {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<Runnable> onSystemEndedHandlers = new CopyOnWriteArrayList();

    @.Inject
    public $DefaultRepositorySystemLifecycle() {
    }

    @Override
    public void systemEnded() {
        if (this.shutdown.compareAndSet(false, true)) {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (Runnable onCloseHandler : this.onSystemEndedHandlers) {
                try {
                    onCloseHandler.run();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            $MultiRuntimeException.mayThrow("system on-close handler failures", exceptions);
        }
    }

    @Override
    public void addOnSystemEndedHandler(Runnable handler) {
        Objects.requireNonNull(handler, "handler cannot be null");
        this.requireNotShutdown();
        this.onSystemEndedHandlers.add(0, handler);
    }

    private void requireNotShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("repository system is already shut down");
        }
    }
}

