/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.internal.impl;

import de.softwareforge.testing.maven.javax.inject.;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositorySystemSession;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$LocalRepositoryProvider;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$PrioritizedComponent;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$PrioritizedComponents;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$Utils;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$LocalRepository;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$LocalRepositoryManager;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$NoLocalRepositoryManagerException;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.localrepo.$LocalRepositoryManagerFactory;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.locator.$Service;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.locator.$ServiceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@.Singleton
@.Named
public class $DefaultLocalRepositoryProvider
implements $LocalRepositoryProvider,
$Service {
    private static final Logger LOGGER = LoggerFactory.getLogger($DefaultLocalRepositoryProvider.class);
    private Collection<$LocalRepositoryManagerFactory> managerFactories = new ArrayList<$LocalRepositoryManagerFactory>();

    @Deprecated
    public $DefaultLocalRepositoryProvider() {
    }

    @.Inject
    public $DefaultLocalRepositoryProvider(Set<$LocalRepositoryManagerFactory> factories) {
        this.setLocalRepositoryManagerFactories(factories);
    }

    @Override
    public void initService($ServiceLocator locator) {
        this.setLocalRepositoryManagerFactories(locator.getServices($LocalRepositoryManagerFactory.class));
    }

    public $DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory($LocalRepositoryManagerFactory factory) {
        this.managerFactories.add(Objects.requireNonNull(factory, "local repository manager factory cannot be null"));
        return this;
    }

    public $DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<$LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<$LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    @Override
    public $LocalRepositoryManager newLocalRepositoryManager($RepositorySystemSession session, $LocalRepository repository) throws $NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        $PrioritizedComponents<$LocalRepositoryManagerFactory> factories = new $PrioritizedComponents<$LocalRepositoryManagerFactory>(session);
        for ($LocalRepositoryManagerFactory $LocalRepositoryManagerFactory : this.managerFactories) {
            factories.add($LocalRepositoryManagerFactory, $LocalRepositoryManagerFactory.getPriority());
        }
        ArrayList<$NoLocalRepositoryManagerException> errors = new ArrayList<$NoLocalRepositoryManagerException>();
        for ($PrioritizedComponent $PrioritizedComponent : factories.getEnabled()) {
            try {
                $LocalRepositoryManager manager = (($LocalRepositoryManagerFactory)$PrioritizedComponent.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(manager.getClass().getSimpleName());
                    $Utils.appendClassLoader(buffer, manager);
                    buffer.append(" with priority ").append($PrioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getBasedir());
                    LOGGER.debug(buffer.toString());
                }
                return manager;
            }
            catch ($NoLocalRepositoryManagerException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain local repository manager for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder.append("No local repository managers registered");
        } else {
            stringBuilder.append("Cannot access ").append(repository.getBasedir());
            stringBuilder.append(" with type ").append(repository.getContentType());
            stringBuilder.append(" using the available factories ");
            factories.list(stringBuilder);
        }
        throw new $NoLocalRepositoryManagerException(repository, stringBuilder.toString(), errors.size() == 1 ? (Throwable)errors.get(0) : null);
    }
}

