/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.apache.maven.repository.internal;

import de.softwareforge.testing.maven.org.apache.maven.model.$Dependency;
import de.softwareforge.testing.maven.org.apache.maven.model.$DependencyManagement;
import de.softwareforge.testing.maven.org.apache.maven.model.$DistributionManagement;
import de.softwareforge.testing.maven.org.apache.maven.model.$Exclusion;
import de.softwareforge.testing.maven.org.apache.maven.model.$License;
import de.softwareforge.testing.maven.org.apache.maven.model.$Model;
import de.softwareforge.testing.maven.org.apache.maven.model.$Prerequisites;
import de.softwareforge.testing.maven.org.apache.maven.model.$Repository;
import de.softwareforge.testing.maven.org.apache.maven.repository.internal.$ArtifactDescriptorUtils;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositorySystemSession;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$Artifact;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$ArtifactType;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$ArtifactTypeRegistry;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$DefaultArtifact;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$DefaultArtifactType;
import de.softwareforge.testing.maven.org.eclipse.aether.resolution.$ArtifactDescriptorResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class $ArtifactDescriptorReaderDelegate {
    public void populateResult($RepositorySystemSession session, $ArtifactDescriptorResult result, $Model model) {
        $ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        for ($Repository $Repository : model.getRepositories()) {
            result.addRepository($ArtifactDescriptorUtils.toRemoteRepository($Repository));
        }
        for ($Dependency $Dependency : model.getDependencies()) {
            result.addDependency(this.convert($Dependency, stereotypes));
        }
        $DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for ($Dependency dependency : mgmt.getDependencies()) {
                result.addManagedDependency(this.convert(dependency, stereotypes));
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        $Prerequisites prerequisites = model.getPrerequisites();
        if (prerequisites != null) {
            linkedHashMap.put("prerequisites.maven", prerequisites.getMaven());
        }
        List<$License> licenses = model.getLicenses();
        linkedHashMap.put("license.count", licenses.size());
        for (int i = 0; i < licenses.size(); ++i) {
            $License license = licenses.get(i);
            linkedHashMap.put("license." + i + ".name", license.getName());
            linkedHashMap.put("license." + i + ".url", license.getUrl());
            linkedHashMap.put("license." + i + ".comments", license.getComments());
            linkedHashMap.put("license." + i + ".distribution", license.getDistribution());
        }
        result.setProperties(linkedHashMap);
        this.setArtifactProperties(result, model);
    }

    private de.softwareforge.testing.maven.org.eclipse.aether.graph.$Dependency convert($Dependency dependency, $ArtifactTypeRegistry stereotypes) {
        $ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new $DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && !dependency.getSystemPath().isEmpty();
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        $DefaultArtifact artifact = new $DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<de.softwareforge.testing.maven.org.eclipse.aether.graph.$Exclusion> exclusions = new ArrayList<de.softwareforge.testing.maven.org.eclipse.aether.graph.$Exclusion>(dependency.getExclusions().size());
        for ($Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        de.softwareforge.testing.maven.org.eclipse.aether.graph.$Dependency result = new de.softwareforge.testing.maven.org.eclipse.aether.graph.$Dependency(($Artifact)artifact, dependency.getScope(), dependency.getOptional() != null ? Boolean.valueOf(dependency.isOptional()) : null, exclusions);
        return result;
    }

    private de.softwareforge.testing.maven.org.eclipse.aether.graph.$Exclusion convert($Exclusion exclusion) {
        return new de.softwareforge.testing.maven.org.eclipse.aether.graph.$Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void setArtifactProperties($ArtifactDescriptorResult result, $Model model) {
        String downloadUrl = null;
        $DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            downloadUrl = distMgmt.getDownloadUrl();
        }
        if (downloadUrl != null && !downloadUrl.isEmpty()) {
            $Artifact artifact = result.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result.setArtifact(artifact.setProperties(props));
        }
    }
}

