/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven;

import de.softwareforge.testing.maven.org.eclipse.aether.util.version.$GenericVersionScheme;
import de.softwareforge.testing.maven.org.eclipse.aether.version.$InvalidVersionSpecificationException;
import de.softwareforge.testing.maven.org.eclipse.aether.version.$Version;
import de.softwareforge.testing.maven.org.eclipse.aether.version.$VersionRange;

interface VersionStrategy {
    public static VersionStrategy partialMatch(String partial) {
        return artifactVersion -> partial.isEmpty() || artifactVersion.toString().equals(partial) || artifactVersion.toString().startsWith(partial + ".");
    }

    public static VersionStrategy exactMatch(String version) {
        return artifactVersion -> artifactVersion.toString().equals(version);
    }

    public static VersionStrategy semVerMatchMajor(int major) {
        return new SemVerVersionStrategy(major, -1);
    }

    public static VersionStrategy semVerMatchMinor(int major, int minor) {
        return new SemVerVersionStrategy(major, minor);
    }

    public boolean matchVersion($Version var1);

    public static class SemVerVersionStrategy
    implements VersionStrategy {
        private static final $GenericVersionScheme SCHEME = new $GenericVersionScheme();
        private final $VersionRange range;

        SemVerVersionStrategy(int major, int minor) {
            StringBuilder matchString = new StringBuilder("[").append(major).append('.');
            if (minor > 0) {
                matchString.append(minor).append('.');
            }
            matchString.append("*]");
            try {
                this.range = SCHEME.parseVersionRange(matchString.toString());
            }
            catch ($InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public boolean matchVersion($Version version) {
            return this.range.containsVersion(version);
        }
    }
}

