/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp.mailstores;

import com.dumbster.smtp.MailMessage;
import com.dumbster.smtp.MailStore;
import com.dumbster.smtp.eml.EMLMailMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMLMailStore
implements MailStore {
    private final Logger LOG = LoggerFactory.getLogger(EMLMailStore.class);
    private AtomicBoolean initialized = new AtomicBoolean();
    private int count = 0;
    private File directory = new File("eml_store");
    private List<MailMessage> messages = new ArrayList<MailMessage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized() {
        EMLMailStore eMLMailStore = this;
        synchronized (eMLMailStore) {
            if (!this.initialized.getAndSet(true)) {
                if (!this.directory.exists()) {
                    this.LOG.debug(String.format("Creating directory '%s'", this.directory.getAbsolutePath()));
                    if (!this.directory.mkdirs()) {
                        throw new UncheckedIOException(new IOException(String.format("Could not create '%s'", this.directory.getAbsolutePath())));
                    }
                } else {
                    this.loadMessages();
                }
            }
        }
    }

    private void loadMessages() {
        File[] files;
        for (File file : files = this.loadMessageFiles()) {
            EMLMailMessage message = new EMLMailMessage(file);
            this.messages.add(message);
        }
        this.count = files.length;
    }

    private File[] loadMessageFiles() {
        File[] files = this.directory.listFiles(new EMLFilenameFilter());
        if (files == null) {
            this.LOG.error(String.format("Unable to load messages from eml mailStore directory '%s'", this.directory));
            return new File[0];
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEmailCount() {
        this.checkInitialized();
        EMLMailStore eMLMailStore = this;
        synchronized (eMLMailStore) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(MailMessage message) {
        File file;
        Objects.requireNonNull(message, "message is null");
        this.checkInitialized();
        EMLMailStore eMLMailStore = this;
        synchronized (eMLMailStore) {
            ++this.count;
            String filename = this.getFilename(message, this.count);
            file = new File(this.directory, filename);
            this.messages.add(message);
        }
        this.LOG.debug("Received message: " + message);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.ISO_8859_1);){
            Iterator<String> i = message.getHeaderNames();
            while (i.hasNext()) {
                String[] values;
                String name = i.next();
                for (String value : values = message.getHeaderValues(name)) {
                    writer.append(name);
                    writer.append(": ");
                    writer.append(value);
                    writer.append('\n');
                }
            }
            writer.append('\n');
            writer.append(message.getBody());
            writer.append('\n');
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getFilename(MailMessage message, int count) {
        Objects.requireNonNull(message, "message is null");
        if (count < 0) {
            throw new IllegalArgumentException("count must be >= 0");
        }
        String filename = count + "_" + message.getFirstHeaderValue("Subject") + ".eml";
        filename = filename.replaceAll("[\\\\/<>\\?>\\*\"\\|]", "_");
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailMessage[] getMessages() {
        this.checkInitialized();
        EMLMailStore eMLMailStore = this;
        synchronized (eMLMailStore) {
            return this.messages.toArray(new MailMessage[this.messages.size()]);
        }
    }

    @Override
    public MailMessage getMessage(int index) {
        return this.getMessages()[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearMessages() {
        EMLMailStore eMLMailStore = this;
        synchronized (eMLMailStore) {
            File[] files = this.directory.listFiles(new EMLFilenameFilter());
            if (files != null) {
                for (File file : files) {
                    if (file.delete()) continue;
                    this.LOG.warn(String.format("Could not delete '%s'", file.getAbsolutePath()));
                }
            }
            this.count = 0;
            this.messages.clear();
        }
    }

    public void setDirectory(String directory) {
        Objects.requireNonNull(directory, "directory is null");
        this.setDirectory(new File(directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectory(File directory) {
        Objects.requireNonNull(directory, "directory is null");
        EMLMailStore eMLMailStore = this;
        synchronized (eMLMailStore) {
            this.directory = directory;
        }
    }

    public static class EMLFilenameFilter
    implements FilenameFilter {
        private final Pattern PATTERN = Pattern.compile("\\d+_.*\\.eml");
        private final Matcher MATCHER = this.PATTERN.matcher("");

        @Override
        public boolean accept(File dir, String name) {
            this.MATCHER.reset(name);
            return this.MATCHER.matches();
        }
    }
}

