/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.util.classpath;

import de.smartics.maven.plugin.jboss.modules.util.Arg;
import de.smartics.maven.plugin.jboss.modules.util.classpath.ClassPathContext;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;

public class ClassPathDirectoryListing {
    private final ClassPathContext context;

    public ClassPathDirectoryListing(ClassLoader classLoader) throws NullPointerException {
        this(new ClassPathContext(classLoader, null));
    }

    public ClassPathDirectoryListing(ClassPathContext context) throws NullPointerException {
        Arg.checkNotNull("context", context);
        this.context = context;
    }

    public final ClassPathContext getClassPathContext() {
        return this.context;
    }

    public List<String> list(String resourcePath) throws NullPointerException, IllegalArgumentException {
        Arg.checkNotNull("resourcePath", resourcePath);
        URL resourcePathUrl = this.context.getResource(resourcePath);
        if (resourcePathUrl == null) {
            throw new IllegalArgumentException("Cannot find resource '" + resourcePath + "' on class path.");
        }
        String protocol = resourcePathUrl.getProtocol();
        if ("file".equals(protocol)) {
            return this.handleFile(resourcePath, resourcePathUrl);
        }
        if ("jar".equals(protocol)) {
            return this.handleJar(resourcePath, resourcePathUrl);
        }
        throw new IllegalArgumentException("Protocol '" + protocol + "' is not supported to resolve resource '" + resourcePath + "'.");
    }

    private List<String> handleFile(String resourcePath, URL resourcePathUrl) throws IllegalArgumentException {
        try {
            String[] contentsArray = new File(resourcePathUrl.toURI()).list();
            return Arrays.asList(contentsArray);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot read URL derived from resource '" + resourcePath + "' on the class path.", e);
        }
    }

    private List<String> handleJar(String resourcePath, URL resourcePathUrl) throws IllegalArgumentException {
        try {
            ArrayList<String> contents = new ArrayList<String>();
            int separatorIndex = resourcePathUrl.getPath().indexOf(33);
            String jarPath = resourcePathUrl.getPath().substring(5, separatorIndex);
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            this.traverseJarEntries(resourcePath, contents, jar);
            return contents;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Read from JAR '" + resourcePath + "'.", e);
        }
    }

    private void traverseJarEntries(String resourcePath, List<String> contents, JarFile jar) {
        int resourcePathLength = resourcePath.length();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String entry;
            String normalized;
            String name = entries.nextElement().getName();
            if (!name.startsWith(resourcePath) || (normalized = ClassPathDirectoryListing.normalize(entry = name.substring(resourcePathLength))) == null || contents.contains(normalized)) continue;
            contents.add(normalized);
        }
    }

    private static String normalize(String entry) {
        int subDirIndex;
        if (StringUtils.isBlank((String)entry)) {
            return null;
        }
        String normalized = entry;
        if (normalized.charAt(0) == '/') {
            if (entry.length() == 1) {
                return null;
            }
            normalized = normalized.substring(1);
        }
        if ((subDirIndex = normalized.indexOf(47)) != -1) {
            normalized = normalized.substring(0, subDirIndex);
        }
        return normalized;
    }
}

