/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.util.classpath;

import de.smartics.maven.plugin.jboss.modules.util.classpath.ClassPathListingFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public abstract class AbstractProjectClassLoader
extends ClassLoader {
    private static final Logger LOG = Logger.getLogger(ClassPathListingFactory.class.getName());

    protected AbstractProjectClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected void ensurePackageProvided(String className) {
        String packageName;
        Package paccage;
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex != -1 && (paccage = this.getPackage(packageName = className.substring(0, lastDotIndex))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }

    protected Class<?> loadClassFile(String className, File classFile) throws ClassNotFoundException {
        Class<?> clazz;
        this.ensurePackageProvided(className);
        BufferedInputStream in = null;
        try {
            Class<?> clazz2;
            in = new BufferedInputStream(new FileInputStream(classFile));
            byte[] data = IOUtils.toByteArray((InputStream)in);
            clazz = clazz2 = this.defineClass(className, data, 0, data.length);
        }
        catch (IOException e) {
            try {
                String message = "Cannot load class '" + className + "' from file '" + classFile + "'.";
                LOG.fine(message);
                throw new ClassNotFoundException(message, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClassFromLibrary(String className, String fileName, File dirName) throws ClassNotFoundException {
        block5: {
            Class<?> clazz;
            this.ensurePackageProvided(className);
            JarFile jarFile = new JarFile(dirName);
            JarEntry entry = jarFile.getJarEntry(fileName);
            if (entry == null) break block5;
            BufferedInputStream in = null;
            try {
                Class<?> clazz2;
                in = new BufferedInputStream(jarFile.getInputStream(entry));
                byte[] data = IOUtils.toByteArray((InputStream)in);
                clazz = clazz2 = this.defineClass(className, data, 0, data.length);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                catch (IOException e) {
                    String message = "Cannot load class '" + className + "' from file '" + dirName + "'.";
                    LOG.fine(message);
                    throw new ClassNotFoundException(message, e);
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            return clazz;
        }
        String message = "Cannot load class '" + className + "' from file '" + dirName + "'.";
        LOG.fine(message);
        throw new ClassNotFoundException(message);
    }

    protected URL loadResourceFromLibrary(String resourceName, String fileName, File dirName) throws IOException {
        this.ensurePackageProvided(resourceName);
        try {
            return new URL("jar:file:" + dirName.getName() + "!/" + fileName);
        }
        catch (IOException e) {
            String message = "Cannot load class '" + resourceName + "' from file '" + dirName + "'.";
            LOG.fine(message);
            IOException ioe = new IOException(message);
            ioe.initCause(e);
            throw ioe;
        }
    }
}

