/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.util;

import de.smartics.maven.plugin.jboss.modules.util.BlankArgumentException;
import de.smartics.maven.plugin.jboss.modules.util.BlankExceptNullArgumentException;
import de.smartics.maven.plugin.jboss.modules.util.NullArgumentException;

public final class Arg {
    private Arg() {
    }

    public static <T> T checkNotNull(String name, T value) throws NullPointerException {
        Arg.checkNotNull(name, value, null);
        return value;
    }

    public static <T> T checkNotNull(String name, T value, String message) throws NullPointerException {
        if (value == null) {
            throw new NullArgumentException(name, message);
        }
        return value;
    }

    public static <T extends CharSequence> T checkNotBlank(String name, T value) throws NullArgumentException, BlankArgumentException {
        Arg.checkNotBlank(name, value, null);
        return value;
    }

    public static <T extends CharSequence> T checkNotBlank(String name, T value, String message) throws NullArgumentException, BlankArgumentException {
        if (value == null) {
            throw new NullArgumentException(name, message);
        }
        if (Arg.isBlank(value)) {
            throw new BlankArgumentException(name, message);
        }
        return value;
    }

    public static <T extends CharSequence> T checkNotBlankExceptNull(String name, T value) throws BlankExceptNullArgumentException {
        Arg.checkNotBlankExceptNull(name, value, null);
        return value;
    }

    public static <T extends CharSequence> T checkNotBlankExceptNull(String name, T value, String message) throws BlankExceptNullArgumentException {
        if (value != null && Arg.isBlank(value)) {
            throw new BlankArgumentException(name, message);
        }
        return value;
    }

    private static <T extends CharSequence> boolean isBlank(T str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

