/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.index;

import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public final class Indexer {
    private final File outputDirectory;
    private final Set<String> fileNames = new TreeSet<String>();

    public Indexer(File outputDirectory) {
        this.outputDirectory = Arg.checkNotNull("outputDirectory", outputDirectory);
    }

    public void add(String fileName) {
        if (StringUtils.isNotBlank((String)fileName)) {
            this.fileNames.add(fileName);
        }
    }

    public void writeIndex() throws MojoExecutionException {
        File indexFile = new File(this.outputDirectory, "META-INF/INDEX.LIST");
        indexFile.getParentFile().mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)indexFile), "UTF-8"));
            for (String fileName : this.fileNames) {
                writer.append(fileName).append('\n');
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(String.format("Cannot write index file '%s'.", indexFile.getAbsoluteFile()), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

