/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain.matching;

import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion;
import de.smartics.maven.plugin.jboss.modules.domain.MatchContext;
import java.util.regex.MatchResult;

public final class DoubleMatchContext
implements MatchContext {
    private final boolean result;
    private final MatchResult groupMatchResult;
    private final MatchResult artifactMatchResult;
    private final ArtifactClusion clusion;

    public DoubleMatchContext(boolean result, MatchContext groupIdContext, MatchContext artifactIdContext, ArtifactClusion clusion) {
        this.result = result;
        this.groupMatchResult = groupIdContext != null && groupIdContext.isMatched() ? groupIdContext.getMatchResult() : null;
        this.artifactMatchResult = artifactIdContext != null && artifactIdContext.isMatched() ? artifactIdContext.getMatchResult() : null;
        this.clusion = clusion;
    }

    @Override
    public boolean isMatched() {
        return this.result;
    }

    @Override
    public MatchResult getMatchResult() {
        return this.artifactMatchResult;
    }

    @Override
    public ArtifactClusion getClusion() {
        return this.clusion;
    }

    @Override
    public String translateName(String input) {
        String translation = input;
        if (this.isMatched()) {
            if (this.artifactMatchResult != null) {
                translation = DoubleMatchContext.translate(this.artifactMatchResult, "$", translation);
            }
            if (this.groupMatchResult != null) {
                translation = DoubleMatchContext.translate(this.groupMatchResult, "$g", translation);
            }
        }
        return translation;
    }

    private static String translate(MatchResult matchResult, String delimiter, String input) {
        String translation = input;
        int groupCount = matchResult.groupCount();
        if (groupCount > 0) {
            for (int group = 1; group <= groupCount; ++group) {
                String replacement = matchResult.group(group);
                translation = translation.replace(delimiter + group, replacement);
            }
        }
        return translation;
    }

    @Override
    public boolean hasGroupMatch() {
        int groupCount;
        if (this.artifactMatchResult != null && this.isMatched() && (groupCount = this.artifactMatchResult.groupCount()) > 0) {
            return true;
        }
        return this.groupMatchResult != null && this.isMatched() && (groupCount = this.groupMatchResult.groupCount()) > 0;
    }
}

