/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.aether.filter;

import java.util.HashMap;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class DependencyFlagger {
    private static final String REJECT_FLAG = "smartics.collect.reject";
    public static final DependencyFlagger INSTANCE = new DependencyFlagger();

    public void flag(DependencyNode node) {
        Dependency dependency = node.getDependency();
        Artifact artifact = dependency.getArtifact();
        node.setArtifact(this.flagRejection(artifact));
    }

    public boolean isFlagged(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        boolean flagged = "true".equals(artifact.getProperty(REJECT_FLAG, null));
        return flagged;
    }

    private Artifact flagRejection(Artifact artifact) {
        HashMap<String, String> properties = new HashMap<String, String>(artifact.getProperties());
        properties.put(REJECT_FLAG, "true");
        return artifact.setProperties(properties);
    }
}

