/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.aether;

import de.smartics.maven.plugin.jboss.modules.aether.DelegateDependencyTraverser;
import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.graph.Dependency;

public class PruningDependencyTraverser
extends DelegateDependencyTraverser {
    private final List<ArtifactClusion> exclusions;
    private final List<ModuleDescriptor> skipModules;

    public PruningDependencyTraverser(DependencyTraverser delegate, List<ArtifactClusion> exclusions, List<ModuleDescriptor> skipModules) throws NullPointerException {
        super(delegate);
        this.exclusions = exclusions;
        this.skipModules = skipModules;
    }

    @Override
    protected boolean doTraverseDependency(Dependency dependency) {
        boolean exclude;
        Artifact artifact = dependency.getArtifact();
        for (ArtifactClusion exclusion : this.exclusions) {
            exclude = exclusion.matches(artifact).isMatched();
            if (!exclude) continue;
            return false;
        }
        for (ModuleDescriptor module : this.skipModules) {
            exclude = module.match(artifact).isMatched();
            if (!exclude) continue;
            return false;
        }
        return true;
    }
}

