/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import java.io.Closeable;

class SimpleJsonEncoder
implements Closeable {
    private static final char QUOTE = '\"';
    private final StringBuilder sb;
    private boolean started;
    private boolean closed;

    SimpleJsonEncoder(StringBuilder sb) {
        this.sb = sb;
        sb.append('{');
    }

    SimpleJsonEncoder appendToJSON(String key, Object value) {
        if (this.closed) {
            throw new IllegalStateException("Encoder already closed");
        }
        if (value != null) {
            this.appendKey(key);
            if (value instanceof Number) {
                this.sb.append(value);
            } else {
                this.sb.append('\"');
                this.escapeString(value.toString());
                this.sb.append('\"');
            }
        }
        return this;
    }

    SimpleJsonEncoder appendToJSONUnquoted(String key, Object value) {
        if (this.closed) {
            throw new IllegalStateException("Encoder already closed");
        }
        if (value != null) {
            this.appendKey(key);
            this.sb.append(value);
        }
        return this;
    }

    private void appendKey(String key) {
        if (this.started) {
            this.sb.append(',');
        } else {
            this.started = true;
        }
        this.sb.append('\"');
        this.escapeString(key);
        this.sb.append('\"');
        this.sb.append(':');
    }

    private void escapeString(String str) {
        block8: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '/': 
                case '\\': {
                    this.sb.append('\\');
                    this.sb.append(ch);
                    continue block8;
                }
                case '\b': {
                    this.sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    this.sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    this.sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                case '\t': {
                    this.sb.append("\\t");
                    continue block8;
                }
                default: {
                    if (ch < ' ') {
                        this.sb.append(SimpleJsonEncoder.escapeCharacter(ch));
                        continue block8;
                    }
                    this.sb.append(ch);
                }
            }
        }
    }

    private static String escapeCharacter(char ch) {
        String prefix = ch < '\u0010' ? "000" : (ch < '\u0100' ? "00" : (ch < '\u1000' ? "0" : ""));
        return "\\u" + prefix + Integer.toHexString(ch);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.sb.append('}');
            this.closed = true;
        }
    }
}

