/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.CustomX509TrustManager;
import de.siegmar.logbackgelf.GelfTcpAppender;
import de.siegmar.logbackgelf.NoopX509TrustManager;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class GelfTcpTlsAppender
extends GelfTcpAppender {
    private boolean insecure;

    public boolean isInsecure() {
        return this.insecure;
    }

    public void setInsecure(boolean insecure) {
        this.insecure = insecure;
    }

    @Override
    protected SSLSocketFactory initSocketFactory() {
        try {
            return this.configureSslFactory(this.newTrustManager());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private TrustManager newTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        if (this.insecure) {
            this.addWarn("Enabled insecure mode (skip TLS certificate validation) - don't use this in production!");
            return new NoopX509TrustManager();
        }
        return new CustomX509TrustManager(GelfTcpTlsAppender.findDefaultX509TrustManager(), this.getGraylogHost());
    }

    private static X509TrustManager findDefaultX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("No X509 TrustManager found");
    }

    private SSLSocketFactory configureSslFactory(TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return context.getSocketFactory();
    }
}

