/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.AbstractGelfAppender;
import de.siegmar.logbackgelf.AddressResolver;
import de.siegmar.logbackgelf.GelfUdpChunker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.zip.DeflaterOutputStream;

public class GelfUdpAppender
extends AbstractGelfAppender {
    private Integer maxChunkSize;
    private boolean useCompression = true;
    private RobustChannel robustChannel;
    private GelfUdpChunker chunker;
    private AddressResolver addressResolver;

    public Integer getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Override
    protected void startAppender() throws IOException {
        this.robustChannel = new RobustChannel();
        this.chunker = new GelfUdpChunker(this.maxChunkSize);
        this.addressResolver = new AddressResolver(this.getGraylogHost());
    }

    @Override
    protected void appendMessage(byte[] binMessage) throws IOException {
        byte[] messageToSend = this.useCompression ? GelfUdpAppender.compress(binMessage) : binMessage;
        InetSocketAddress remote = new InetSocketAddress(this.addressResolver.resolve(), this.getGraylogPort());
        for (ByteBuffer byteBuffer : this.chunker.chunks(messageToSend)) {
            while (byteBuffer.hasRemaining()) {
                this.robustChannel.send(byteBuffer, remote);
            }
        }
    }

    private static byte[] compress(byte[] binMessage) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(binMessage.length);
        try (DeflaterOutputStream deflaterOut = new DeflaterOutputStream(bos);){
            ((OutputStream)deflaterOut).write(binMessage);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bos.toByteArray();
    }

    @Override
    protected void close() throws IOException {
        this.robustChannel.close();
    }

    private static final class RobustChannel {
        private volatile DatagramChannel channel = DatagramChannel.open();
        private volatile boolean stopped;

        RobustChannel() throws IOException {
        }

        void send(ByteBuffer src, SocketAddress target) throws IOException {
            this.getChannel().send(src, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatagramChannel getChannel() throws IOException {
            DatagramChannel tmp = this.channel;
            if (!tmp.isOpen()) {
                RobustChannel robustChannel = this;
                synchronized (robustChannel) {
                    tmp = this.channel;
                    if (!tmp.isOpen() && !this.stopped) {
                        this.channel = tmp = DatagramChannel.open();
                    }
                }
            }
            return tmp;
        }

        synchronized void close() throws IOException {
            this.channel.close();
            this.stopped = true;
        }
    }
}

