/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.GelfTcpAppender;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class GelfTcpTlsAppender
extends GelfTcpAppender {
    private boolean trustAllCertificates;

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    @Override
    protected SSLSocketFactory initSocketFactory() {
        if (this.trustAllCertificates) {
            this.addWarn("Enable trustAllCertificates - don't use this in production!");
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, GelfTcpTlsAppender.buildNoopTrustManagers(), new SecureRandom());
                return context.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    private static TrustManager[] buildNoopTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
    }
}

