/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.SimpleJsonEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

class GelfMessage {
    private static final String VERSION = "1.1";
    private final String host;
    private final String shortMessage;
    private final String fullMessage;
    private final double timestamp;
    private final int level;
    private final Map<String, Object> additionalFields;

    GelfMessage(String host, String shortMessage, String fullMessage, double timestamp, int level, Map<String, Object> additionalFields) {
        this.host = Objects.requireNonNull(host, "host must not be null");
        this.shortMessage = Objects.requireNonNull(shortMessage, "shortMessage must not be null");
        this.fullMessage = fullMessage == null || fullMessage.isEmpty() ? null : fullMessage;
        this.timestamp = timestamp;
        this.level = level;
        this.additionalFields = Objects.requireNonNull(additionalFields, "additionalFields must not be null");
    }

    String toJSON() {
        SimpleJsonEncoder jsonEncoder = new SimpleJsonEncoder();
        DecimalFormat decimalFormat = new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        jsonEncoder.appendToJSON("version", VERSION).appendToJSON("host", this.host).appendToJSON("short_message", this.shortMessage).appendToJSON("full_message", this.fullMessage).appendToJSONUnquoted("timestamp", decimalFormat.format(this.timestamp)).appendToJSONUnquoted("level", this.level);
        for (Map.Entry<String, Object> entry : this.additionalFields.entrySet()) {
            jsonEncoder.appendToJSON('_' + entry.getKey(), entry.getValue());
        }
        return jsonEncoder.toString();
    }
}

