/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CommentStrategy;
import de.siegmar.fastcsv.reader.CsvRow;
import de.siegmar.fastcsv.reader.RowHandler;
import java.io.IOException;
import java.io.Reader;

final class RowReader {
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final int STATUS_LAST_CHAR_WAS_CR = 32;
    private static final int STATUS_COMMENTED_ROW = 16;
    private static final int STATUS_NEW_FIELD = 8;
    private static final int STATUS_QUOTED_MODE = 4;
    private static final int STATUS_QUOTED_COLUMN = 2;
    private static final int STATUS_DATA_COLUMN = 1;
    private static final int STATUS_RESET = 0;
    private final RowHandler rowHandler = new RowHandler(32);
    private final Buffer buffer;
    private final char fsep;
    private final char qChar;
    private final CommentStrategy cStrat;
    private final char cChar;
    private int status;
    private boolean finished;

    RowReader(Reader reader, char fieldSeparator, char quoteCharacter, CommentStrategy commentStrategy, char commentCharacter) {
        this.buffer = new Buffer(reader);
        this.fsep = fieldSeparator;
        this.qChar = quoteCharacter;
        this.cStrat = commentStrategy;
        this.cChar = commentCharacter;
    }

    CsvRow fetchAndRead() throws IOException {
        if (this.finished) {
            return null;
        }
        do {
            if (this.buffer.len != this.buffer.pos || !this.buffer.fetchData()) continue;
            if (this.buffer.begin < this.buffer.pos || this.rowHandler.isCommentMode()) {
                this.rowHandler.add(RowReader.materialize(this.buffer.buf, this.buffer.begin, this.buffer.pos - this.buffer.begin, this.status, this.qChar), this.buffer.relativeOffset + (long)this.buffer.begin);
            } else if ((this.status & 8) != 0) {
                this.rowHandler.add("", this.buffer.relativeOffset + (long)this.buffer.begin);
            }
            this.finished = true;
            break;
        } while (this.consume(this.rowHandler, this.buffer.buf, this.buffer.len));
        return this.rowHandler.buildAndReset();
    }

    boolean consume(RowHandler rh, char[] lBuf, int lLen) {
        boolean moreDataNeeded;
        int lBegin;
        int lPos;
        block20: {
            lPos = this.buffer.pos;
            lBegin = this.buffer.begin;
            int lStatus = this.status;
            moreDataNeeded = true;
            block0: do {
                char lookAhead;
                char c;
                if ((lStatus & 4) != 0) {
                    block1: while (lPos < lLen) {
                        if ((c = lBuf[lPos++]) == this.qChar) {
                            lStatus &= 0xFFFFFFFB;
                            continue block0;
                        }
                        if (c == '\r') {
                            lStatus |= 0x20;
                            rh.incLines();
                            continue;
                        }
                        if (c == '\n') {
                            if ((lStatus & 0x20) == 0) {
                                rh.incLines();
                                continue;
                            }
                            lStatus &= 0xFFFFFFDF;
                            continue;
                        }
                        while (lPos < lLen) {
                            if ((lookAhead = lBuf[lPos++]) != this.qChar && lookAhead != '\n' && lookAhead != '\r') continue;
                            --lPos;
                            continue block1;
                        }
                    }
                    continue;
                }
                if ((lStatus & 0x10) != 0) {
                    while (lPos < lLen) {
                        char lookAhead2;
                        if ((lookAhead2 = lBuf[lPos++]) == '\r') {
                            rh.add(RowReader.materialize(lBuf, lBegin, lPos - lBegin - 1, lStatus, this.qChar), this.buffer.relativeOffset + (long)lBegin);
                            this.status = 32;
                            lBegin = lPos;
                            moreDataNeeded = false;
                        } else {
                            if (lookAhead2 != '\n') continue;
                            rh.add(RowReader.materialize(lBuf, lBegin, lPos - lBegin - 1, lStatus, this.qChar), this.buffer.relativeOffset + (long)lBegin);
                            this.status = 0;
                            lBegin = lPos;
                            moreDataNeeded = false;
                        }
                        break block20;
                    }
                    continue;
                }
                block4: while (lPos < lLen) {
                    if ((c = lBuf[lPos++]) == this.fsep) {
                        rh.add(RowReader.materialize(lBuf, lBegin, lPos - lBegin - 1, lStatus, this.qChar), this.buffer.relativeOffset + (long)lBegin);
                        lStatus = 8;
                        lBegin = lPos;
                        continue;
                    }
                    if (c == '\r') {
                        rh.add(RowReader.materialize(lBuf, lBegin, lPos - lBegin - 1, lStatus, this.qChar), this.buffer.relativeOffset + (long)lBegin);
                        this.status = 32;
                        lBegin = lPos;
                        moreDataNeeded = false;
                        break block20;
                    }
                    if (c == '\n') {
                        if ((lStatus & 0x20) == 0) {
                            rh.add(RowReader.materialize(lBuf, lBegin, lPos - lBegin - 1, lStatus, this.qChar), this.buffer.relativeOffset + (long)lBegin);
                            this.status = 0;
                            lBegin = lPos;
                            moreDataNeeded = false;
                            break block20;
                        }
                        lStatus = 0;
                        lBegin = lPos;
                        continue;
                    }
                    if (this.cStrat != CommentStrategy.NONE && c == this.cChar && (lStatus == 0 || lStatus == 32)) {
                        lBegin = lPos;
                        lStatus = 16;
                        rh.enableCommentMode();
                        continue block0;
                    }
                    if (c == this.qChar) {
                        lStatus = 6;
                        continue block0;
                    }
                    if ((lStatus & 2) != 0) continue;
                    lStatus = 1;
                    while (lPos < lLen) {
                        if ((lookAhead = lBuf[lPos++]) != this.fsep && lookAhead != '\n' && lookAhead != '\r') continue;
                        --lPos;
                        continue block4;
                    }
                }
            } while (lPos < lLen);
            this.status = lStatus;
        }
        this.buffer.pos = lPos;
        this.buffer.begin = lBegin;
        return moreDataNeeded;
    }

    private static String materialize(char[] lBuf, int lBegin, int lPos, int lStatus, char quoteCharacter) {
        if ((lStatus & 2) == 0) {
            return new String(lBuf, lBegin, lPos);
        }
        int shift = RowReader.cleanDelimiters(lBuf, lBegin + 1, lBegin + lPos, quoteCharacter);
        return new String(lBuf, lBegin + 1, lPos - 1 - shift);
    }

    private static int cleanDelimiters(char[] buf, int begin, int pos, char quoteCharacter) {
        int shift = 0;
        boolean escape = false;
        for (int i = begin; i < pos; ++i) {
            char c = buf[i];
            if (c == quoteCharacter) {
                if (!escape) {
                    ++shift;
                    escape = true;
                    continue;
                }
                escape = false;
            }
            if (shift <= 0) continue;
            buf[i - shift] = c;
        }
        return shift;
    }

    public void resetBuffer() {
        this.buffer.reset();
        this.rowHandler.reset();
    }

    private static class Buffer {
        private static final int READ_SIZE = 8192;
        private static final int BUFFER_SIZE = 8192;
        private static final int MAX_BUFFER_SIZE = 0x800000;
        char[] buf = new char[8192];
        int len;
        int begin;
        int pos;
        long relativeOffset;
        private final Reader reader;

        Buffer(Reader reader) {
            this.reader = reader;
        }

        private boolean fetchData() throws IOException {
            int cnt;
            if (this.begin < this.pos) {
                if (8192 > this.buf.length - this.pos) {
                    int lenToCopy = this.pos - this.begin;
                    if (8192 > this.buf.length - lenToCopy) {
                        this.buf = Buffer.extendAndRelocate(this.buf, this.begin);
                    } else {
                        System.arraycopy(this.buf, this.begin, this.buf, 0, lenToCopy);
                    }
                    this.pos -= this.begin;
                    this.relativeOffset += (long)this.begin;
                    this.begin = 0;
                }
            } else {
                this.relativeOffset += (long)this.begin;
                this.begin = 0;
                this.pos = 0;
            }
            if ((cnt = this.reader.read(this.buf, this.pos, 8192)) == -1) {
                return true;
            }
            this.len = this.pos + cnt;
            return false;
        }

        private static char[] extendAndRelocate(char[] buf, int begin) throws IOException {
            int newBufferSize = buf.length * 2;
            if (newBufferSize > 0x800000) {
                throw new IOException("Maximum buffer size 8388608 is not enough to read data of a single field. Typically, this happens if quotation started but did not end within this buffer's maximum boundary.");
            }
            char[] newBuf = new char[newBufferSize];
            System.arraycopy(buf, begin, newBuf, 0, buf.length - begin);
            return newBuf;
        }

        public void reset() {
            this.len = 0;
            this.begin = 0;
            this.pos = 0;
            this.relativeOffset = 0L;
        }
    }
}

