/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.Behavior;
import com.alee.managers.drag.DragManager;
import com.alee.utils.CompareUtils;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class AbstractObjectHoverBehavior<C extends JComponent, V>
extends MouseAdapter
implements ComponentListener,
Behavior {
    protected final C component;
    protected boolean enabledOnly;
    protected V hoverObject;

    public AbstractObjectHoverBehavior(C component) {
        this(component, true);
    }

    public AbstractObjectHoverBehavior(C component, boolean enabledOnly) {
        this.enabledOnly = enabledOnly;
        this.component = component;
    }

    public void install() {
        ((Component)this.component).addMouseListener(this);
        ((Component)this.component).addMouseMotionListener(this);
        ((Component)this.component).addComponentListener(this);
    }

    public void uninstall() {
        ((Component)this.component).removeMouseListener(this);
        ((Component)this.component).removeMouseMotionListener(this);
        ((Component)this.component).removeComponentListener(this);
    }

    public boolean isEnabledOnly() {
        return this.enabledOnly;
    }

    public void setEnabledOnly(boolean enabledOnly) {
        this.enabledOnly = enabledOnly;
        this.updateHover();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateHover(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateHover(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateHover(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.clearHover();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateHover();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.updateHover();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateHover();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.updateHover();
    }

    protected void updateHover() {
        if (((Component)this.component).isShowing() && !DragManager.isDragging()) {
            Point mousePoint = CoreSwingUtils.getMousePoint(this.component);
            if (((JComponent)this.component).getVisibleRect().contains(mousePoint)) {
                this.updateHover(mousePoint);
            } else {
                this.clearHover();
            }
        } else {
            this.clearHover();
        }
    }

    protected void updateHover(MouseEvent e) {
        this.updateHover(e.getPoint());
    }

    protected void updateHover(Point point) {
        if (!this.enabledOnly || ((Component)this.component).isEnabled()) {
            this.checkHoverChange(this.getObjectAt(point));
        }
    }

    protected abstract V getObjectAt(Point var1);

    protected void clearHover() {
        this.checkHoverChange(null);
    }

    protected void checkHoverChange(V object) {
        if (!CompareUtils.equals(object, (Object[])new Object[]{this.hoverObject})) {
            V previousPath = this.hoverObject;
            this.hoverObject = object;
            this.hoverChanged(previousPath, this.hoverObject);
        }
    }

    public abstract void hoverChanged(V var1, V var2);
}

