/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.global.StyleConstants;
import com.alee.managers.log.Log;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.UIDefaults;

public final class ProprietaryUtils {
    public static final int LIGHT_WEIGHT_POPUP = 0;
    public static final int MEDIUM_WEIGHT_POPUP = 1;
    public static final int HEAVY_WEIGHT_POPUP = 2;
    private static boolean windowTransparencyAllowed = true;
    private static boolean windowShapeAllowed = true;
    private static boolean allowLinuxTransparency = false;

    public static boolean isAllowLinuxTransparency() {
        return allowLinuxTransparency;
    }

    public static void setAllowLinuxTransparency(boolean allow) {
        allowLinuxTransparency = allow;
    }

    public static void setupUIDefaults(UIDefaults table) {
        try {
            Class su2 = ReflectUtils.getClass((String)"sun.swing.SwingUtilities2");
            Object aaProperty = ReflectUtils.getStaticFieldValue((Class)su2, (String)"AA_TEXT_PROPERTY_KEY");
            Class aaTextInfo = ReflectUtils.getInnerClass((Class)su2, (String)"AATextInfo");
            Object aaValue = ReflectUtils.callStaticMethod((Class)aaTextInfo, (String)"getAATextInfo", (Object[])new Object[]{true});
            table.put(aaProperty, aaValue);
        }
        catch (ClassNotFoundException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.error(ProprietaryUtils.class, (Throwable)e);
        }
    }

    public static boolean isWindowTransparencyAllowed() {
        try {
            if (windowTransparencyAllowed) {
                Class au = ReflectUtils.getClass((String)"com.sun.awt.AWTUtilities");
                Class t = ReflectUtils.getInnerClass((Class)au, (String)"Translucency");
                Object ppt = ReflectUtils.getStaticFieldValue((Class)t, (String)"PERPIXEL_TRANSPARENT");
                Boolean wts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isWindowTranslucencySupported", (Object[])new Object[0]);
                Boolean tc = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isTranslucencyCapable", (Object[])new Object[]{SystemUtils.getGraphicsConfiguration()});
                Boolean ppts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isTranslucencySupported", (Object[])new Object[]{ppt});
                return wts != false && tc != false && ppts != false && (SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris() || SystemUtils.isUnix() && allowLinuxTransparency);
            }
            return false;
        }
        catch (Throwable e) {
            return SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris() || SystemUtils.isUnix() && allowLinuxTransparency;
        }
    }

    public static void setWindowTransparencyAllowed(boolean allowed) {
        windowTransparencyAllowed = allowed;
    }

    public static boolean isWindowShapeAllowed() {
        try {
            if (windowShapeAllowed) {
                Class au = ReflectUtils.getClass((String)"com.sun.awt.AWTUtilities");
                Class t = ReflectUtils.getInnerClass((Class)au, (String)"Translucency");
                Object ppt = ReflectUtils.getStaticFieldValue((Class)t, (String)"PERPIXEL_TRANSPARENT");
                Boolean wts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isWindowShapingSupported", (Object[])new Object[0]);
                Boolean ppts = (Boolean)ReflectUtils.callStaticMethod((Class)au, (String)"isTranslucencySupported", (Object[])new Object[]{ppt});
                return wts != false && ppts != false;
            }
            return false;
        }
        catch (Throwable e) {
            return windowShapeAllowed;
        }
    }

    public static void setWindowShapeAllowed(boolean allowed) {
        windowShapeAllowed = allowed;
    }

    public static void setWindowOpaque(Window window, boolean opaque) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ProprietaryUtils.setupOpacityBackgroundColor(opaque, window);
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowOpaque", (Object[])new Object[]{window, opaque});
                }
                JRootPane rootPane = SwingUtils.getRootPane(window);
                if (rootPane != null) {
                    ProprietaryUtils.setupOpacityBackgroundColor(opaque, rootPane);
                    rootPane.setOpaque(opaque);
                    Container container = rootPane.getContentPane();
                    if (container != null) {
                        ProprietaryUtils.setupOpacityBackgroundColor(opaque, container);
                        if (container instanceof JComponent) {
                            ((JComponent)container).setOpaque(opaque);
                        }
                    }
                    rootPane.repaint();
                }
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, (Throwable)e);
            }
        }
    }

    private static void setupOpacityBackgroundColor(boolean opaque, Component component) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ReflectUtils.callMethod((Object)component, (String)"setBackground", (Object[])new Object[]{opaque ? Color.WHITE : StyleConstants.transparent});
    }

    public static boolean isWindowOpaque(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Color bg;
                Boolean isOpaque = SystemUtils.isJava7orAbove() ? Boolean.valueOf((bg = (Color)ReflectUtils.callMethod((Object)window, (String)"getBackground", (Object[])new Object[0])).getAlpha() == 255) : (Boolean)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"isWindowOpaque", (Object[])new Object[]{window});
                return isOpaque != null ? isOpaque : true;
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, (Throwable)e);
            }
        }
        return true;
    }

    public static void setWindowOpacity(Window window, float opacity) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod((Object)window, (String)"setOpacity", (Object[])new Object[]{Float.valueOf(opacity)});
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowOpacity", (Object[])new Object[]{window, Float.valueOf(opacity)});
                }
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, (Throwable)e);
            }
        }
    }

    public static float getWindowOpacity(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Float opacity = SystemUtils.isJava7orAbove() ? (Float)ReflectUtils.callMethod((Object)window, (String)"getOpacity", (Object[])new Object[0]) : (Float)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"getWindowOpacity", (Object[])new Object[]{window});
                return opacity != null ? opacity.floatValue() : 1.0f;
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, (Throwable)e);
            }
        }
        return 1.0f;
    }

    public static void setWindowShape(Window window, Shape shape) {
        if (window != null && ProprietaryUtils.isWindowShapeAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod((Object)window, (String)"setShape", (Object[])new Object[]{shape});
                } else {
                    ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setWindowShape", (Object[])new Object[]{window, shape});
                }
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, (Throwable)e);
            }
        }
    }

    public static Shape getWindowShape(Window window) {
        if (window != null && ProprietaryUtils.isWindowShapeAllowed()) {
            try {
                Shape shape = SystemUtils.isJava7orAbove() ? (Shape)ReflectUtils.callMethod((Object)window, (String)"getShape", (Object[])new Object[0]) : (Shape)ReflectUtils.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"getWindowShape", (Object[])new Object[]{window});
                return shape;
            }
            catch (Throwable e) {
                Log.error(ProprietaryUtils.class, (Throwable)e);
            }
        }
        return null;
    }
}

