/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.global.StyleConstants;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.managers.log.Log;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Styleable;
import com.alee.painter.common.TexturePainter;
import com.alee.utils.GeometryUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.laf.FocusType;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.xml.ResourceFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;

public final class LafUtils {
    private static final Map<String, GradientPaint> gradientCache = new HashMap<String, GradientPaint>();
    public static int halfButton = 4;
    public static int halfSelector = 2;
    public static int halfLine = 1;
    public static int shadeWidth = 2;
    private static final NinePatchIcon conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/conn.9.png"));
    private static final NinePatchIcon lr_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/lr_conn.9.png"));
    private static final NinePatchIcon ud_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/ud_conn.9.png"));
    private static final NinePatchIcon corners_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/corners_conn.9.png"));
    private static final NinePatchIcon full_conn = new NinePatchIcon(LafUtils.class.getResource("icons/selection/full_conn.9.png"));
    private static final NinePatchIcon lr = new NinePatchIcon(LafUtils.class.getResource("icons/selection/lr.9.png"));
    private static final NinePatchIcon ud = new NinePatchIcon(LafUtils.class.getResource("icons/selection/ud.9.png"));
    private static final NinePatchIcon corners = new NinePatchIcon(LafUtils.class.getResource("icons/selection/corners.9.png"));
    private static final NinePatchIcon full = new NinePatchIcon(LafUtils.class.getResource("icons/selection/full.9.png"));
    private static final ImageIcon gripper = new ImageIcon(LafUtils.class.getResource("icons/selection/gripper.png"));
    private static final Map<Integer, NinePatchIcon> selectorCache = new HashMap<Integer, NinePatchIcon>();

    public static boolean isInDecoratedWindow(Component component) {
        RootPaneUI ui;
        JRootPane rootPane = SwingUtils.getRootPane(component);
        if (rootPane != null && (ui = rootPane.getUI()) instanceof WebRootPaneUI) {
            return ((WebRootPaneUI)ui).isDecorated();
        }
        return false;
    }

    public static Insets getMargin(Component component) {
        if (component instanceof MarginSupport) {
            return ((MarginSupport)((Object)component)).getMargin();
        }
        Object ui = LafUtils.getUI(component);
        if (ui instanceof MarginSupport) {
            return ((MarginSupport)ui).getMargin();
        }
        return null;
    }

    public static Insets getPadding(Component component) {
        if (component instanceof PaddingSupport) {
            return ((PaddingSupport)((Object)component)).getPadding();
        }
        Object ui = LafUtils.getUI(component);
        if (ui instanceof PaddingSupport) {
            return ((PaddingSupport)ui).getPadding();
        }
        return null;
    }

    public static Insets getInsets(Component component) {
        if (component instanceof JComponent) {
            return ((JComponent)component).getInsets();
        }
        return null;
    }

    public static <T extends ComponentUI> T getUI(Component component) {
        return (T)((ComponentUI)ReflectUtils.callMethodSafely((Object)component, (String)"getUI", (Object[])new Object[0]));
    }

    public static void drawAlphaLayer(Graphics2D g2d, int x, int y, int width, int height) {
        LafUtils.drawAlphaLayer(g2d, x, y, width, height, StyleConstants.ALPHA_RECT_SIZE);
    }

    public static void drawAlphaLayer(Graphics2D g2d, int x, int y, int width, int height, int size) {
        LafUtils.drawAlphaLayer(g2d, x, y, width, height, size, StyleConstants.LIGHT_ALPHA, StyleConstants.DARK_ALPHA);
    }

    public static void drawAlphaLayer(Graphics2D g2d, int x, int y, int width, int height, int size, Color light, Color dark) {
        int xAmount = width / size + 1;
        int yAmount = height / size + 1;
        for (int i = 0; i < xAmount; ++i) {
            for (int j = 0; j < yAmount; ++j) {
                Color color;
                boolean lightColor = (i + j) % 2 == 0;
                Color color2 = color = lightColor ? light : dark;
                if (color == null) continue;
                g2d.setPaint(color);
                int w = x + i * size + size > x + width ? width - i * size : size;
                int h = y + j * size + size > y + height ? height - j * size : size;
                g2d.fillRect(x + i * size, y + j * size, w, h);
            }
        }
    }

    public static Rectangle getTextBounds(String text, Graphics g, Font font) {
        return LafUtils.getTextBounds(text, (Graphics2D)g, font);
    }

    public static Rectangle getTextBounds(String text, Graphics2D g2d, Font font) {
        FontRenderContext renderContext = g2d.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(renderContext, text);
        return glyphVector.getVisualBounds().getBounds();
    }

    @Deprecated
    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, StyleConstants.darkBorderColor, StyleConstants.disabledBorderColor);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, Color border) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, border, border);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, Color border, Color disabledBorder) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, border, disabledBorder, 1.0f);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, Color border, Color disabledBorder, float opacity) {
        return LafUtils.drawWebStyle(g2d, component, shadeColor, shadeWidth, round, fillBackground, webColored, border, disabledBorder, component.getBackground(), opacity);
    }

    public static Shape drawWebStyle(Graphics2D g2d, JComponent component, Color shadeColor, int shadeWidth, int round, boolean fillBackground, boolean webColored, Color border, Color disabledBorder, Color background, float opacity) {
        if (opacity <= 0.0f || opacity > 1.0f) {
            return null;
        }
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Composite oc = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(opacity), (opacity < 1.0f ? 1 : 0) != 0);
        Shape borderShape = LafUtils.getWebBorderShape(component, shadeWidth, round);
        if (component.isEnabled() && shadeColor != null) {
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)borderShape, (Color)shadeColor, (int)shadeWidth);
        }
        if (fillBackground) {
            g2d.setPaint(webColored ? LafUtils.getWebGradientPaint(0, shadeWidth, 0, component.getHeight() - shadeWidth) : background);
            if (round > 0) {
                g2d.fillRoundRect(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2, component.getHeight() - shadeWidth * 2, round * 2 + 2, round * 2 + 2);
            } else {
                g2d.fillRect(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2, component.getHeight() - shadeWidth * 2);
            }
        }
        if (border != null) {
            g2d.setPaint(component.isEnabled() ? border : disabledBorder);
            g2d.draw(borderShape);
        }
        GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)oc, (opacity < 1.0f ? 1 : 0) != 0);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        return borderShape;
    }

    public static GradientPaint getWebGradientPaint(Rectangle bounds) {
        return LafUtils.getWebGradientPaint(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
    }

    public static GradientPaint getWebGradientPaint(int x1, int y1, int x2, int y2) {
        String key = x1 + ";" + y1 + ";" + x2 + ";" + y2;
        if (gradientCache.containsKey(key)) {
            return gradientCache.get(key);
        }
        GradientPaint gp = new GradientPaint(x1, y1, StyleConstants.topBgColor, x2, y2, StyleConstants.bottomBgColor);
        gradientCache.put(key, gp);
        return gp;
    }

    public static Shape getWebBorderShape(JComponent component, int shadeWidth, int round) {
        if (round > 0) {
            return new RoundRectangle2D.Double(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2 - 1, component.getHeight() - shadeWidth * 2 - 1, round * 2, round * 2);
        }
        return new Rectangle2D.Double(shadeWidth, shadeWidth, component.getWidth() - shadeWidth * 2 - 1, component.getHeight() - shadeWidth * 2 - 1);
    }

    public static void drawCustomWebBorder(Graphics2D g2d, JComponent component, Shape borderShape, Color shadeColor, int shadeWidth, boolean fillBackground, boolean webColored) {
        LafUtils.drawCustomWebBorder(g2d, component, borderShape, shadeColor, shadeWidth, fillBackground, webColored, Color.GRAY, Color.LIGHT_GRAY);
    }

    public static void drawCustomWebBorder(Graphics2D g2d, JComponent component, Shape borderShape, Color shadeColor, int shadeWidth, boolean fillBackground, boolean webColored, Color border, Color disabledBorder) {
        LafUtils.drawCustomWebBorder(g2d, component, borderShape, shadeColor, shadeWidth, fillBackground, webColored, border, disabledBorder, component.getBackground());
    }

    public static void drawCustomWebBorder(Graphics2D g2d, JComponent component, Shape borderShape, Color shadeColor, int shadeWidth, boolean fillBackground, boolean webColored, Color border, Color disabledBorder, Color backgroundColor) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        if (component.isEnabled()) {
            GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)borderShape, (Color)shadeColor, (int)shadeWidth);
        }
        if (fillBackground) {
            if (webColored) {
                Rectangle shapeBounds = borderShape.getBounds();
                g2d.setPaint(new GradientPaint(0.0f, shapeBounds.y, StyleConstants.topBgColor, 0.0f, shapeBounds.y + shapeBounds.height, StyleConstants.bottomBgColor));
                g2d.fill(borderShape);
            } else {
                g2d.setPaint(backgroundColor);
                g2d.fill(borderShape);
            }
        }
        if (border != null) {
            g2d.setPaint(component.isEnabled() ? border : disabledBorder);
            g2d.draw(borderShape);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static void drawCustomWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, Shape shape) {
        LafUtils.drawCustomWebFocus(g2d, component, focusType, shape, null);
    }

    public static void drawCustomWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, Shape shape, Boolean mouseover) {
        LafUtils.drawCustomWebFocus(g2d, component, focusType, shape, mouseover, null);
    }

    public static void drawCustomWebFocus(Graphics2D g2d, JComponent component, FocusType focusType, Shape shape, Boolean mouseover, Boolean hasFocus) {
        if ((hasFocus = Boolean.valueOf(hasFocus != null ? hasFocus : component.hasFocus() && component.isEnabled())).booleanValue() && focusType.equals((Object)FocusType.componentFocus)) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)StyleConstants.focusStroke);
            g2d.setPaint(StyleConstants.focusColor);
            g2d.draw(shape);
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        } else if (focusType.equals((Object)FocusType.fieldFocus) && (hasFocus.booleanValue() || mouseover != null && mouseover.booleanValue())) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)StyleConstants.fieldFocusStroke);
            g2d.setPaint(hasFocus != false ? StyleConstants.fieldFocusColor : StyleConstants.transparentFieldFocusColor);
            g2d.draw(shape);
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        }
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, int x, int y, int width, int height, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        LafUtils.drawWebSelection(g2d, color, new Rectangle(x, y, width, height), resizableLR, resizableUD, drawConnectors);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, int x, int y, int width, int height, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        LafUtils.drawWebSelection(g2d, color, new Rectangle(x, y, width, height), resizableLR, resizableUD, drawConnectors, drawSideControls);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        LafUtils.drawWebSelection(g2d, color, selection, resizableLR, resizableUD, drawConnectors, true);
    }

    public static void drawWebSelection(Graphics2D g2d, Color color, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Area buttonsShape = new Area();
        if (resizableUD) {
            if (resizableLR) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (drawSideControls) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width / 2 - halfButton, selection.y - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (resizableLR && drawSideControls) {
            buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y + selection.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
            buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y + selection.height / 2 - halfButton, halfButton * 2, halfButton * 2)));
        }
        if (resizableUD) {
            if (resizableLR) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
            }
            if (drawSideControls) {
                buttonsShape.add(new Area(new Ellipse2D.Double(selection.x + selection.width / 2 - halfButton, selection.y + selection.height - halfButton, halfButton * 2, halfButton * 2)));
            }
        }
        if (drawConnectors) {
            Area selectionShape = new Area(new RoundRectangle2D.Double(selection.x - halfLine, selection.y - halfLine, selection.width + halfLine * 2, selection.height + halfLine * 2, 5.0, 5.0));
            selectionShape.subtract(new Area(new RoundRectangle2D.Double(selection.x + halfLine, selection.y + halfLine, selection.width - halfLine * 2, selection.height - halfLine * 2, 3.0, 3.0)));
            buttonsShape.add(selectionShape);
        }
        GraphicsUtils.drawShade((Graphics2D)g2d, (Shape)buttonsShape, (Color)Color.GRAY, (int)shadeWidth);
        g2d.setPaint(Color.GRAY);
        g2d.draw(buttonsShape);
        g2d.setPaint(color);
        g2d.fill(buttonsShape);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static void drawWebSelector(Graphics2D g2d, Color color, Rectangle selection, int selector) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Ellipse2D.Double buttonsShape = selector == 8 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 1 ? new Ellipse2D.Double(selection.x + selection.width / 2 - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 2 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 7 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y + selection.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 3 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y + selection.height / 2 - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 6 ? new Ellipse2D.Double(selection.x - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 5 ? new Ellipse2D.Double(selection.x + selection.width / 2 - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : (selector == 4 ? new Ellipse2D.Double(selection.x + selection.width - halfSelector, selection.y + selection.height - halfSelector, halfSelector * 2, halfSelector * 2) : null)))))));
        g2d.setPaint(color);
        g2d.fill(buttonsShape);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    public static void drawWebIconedSelection(Graphics2D g2d, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors) {
        LafUtils.drawWebIconedSelection(g2d, selection, resizableLR, resizableUD, drawConnectors, true);
    }

    public static void drawWebIconedSelection(Graphics2D g2d, Rectangle selection, boolean resizableLR, boolean resizableUD, boolean drawConnectors, boolean drawSideControls) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Rectangle rect = LafUtils.calculateIconedRect(selection);
        if (drawConnectors) {
            if (!resizableLR && !resizableUD) {
                conn.paintIcon(g2d, rect);
            } else if (resizableLR && !resizableUD && drawSideControls) {
                lr_conn.paintIcon(g2d, rect);
            } else if (!resizableLR && resizableUD && drawSideControls) {
                ud_conn.paintIcon(g2d, rect);
            } else if (resizableLR && resizableUD) {
                if (drawSideControls) {
                    full_conn.paintIcon(g2d, rect);
                } else {
                    corners_conn.paintIcon(g2d, rect);
                }
            }
        } else if (resizableLR && !resizableUD && drawSideControls) {
            lr.paintIcon(g2d, rect);
        } else if (!resizableLR && resizableUD && drawSideControls) {
            ud.paintIcon(g2d, rect);
        } else if (resizableLR && resizableUD) {
            if (drawSideControls) {
                full.paintIcon(g2d, rect);
            } else {
                corners.paintIcon(g2d, rect);
            }
        }
    }

    public static void drawWebIconedSelector(Graphics2D g2d, Rectangle selection, int selector) {
        selection = GeometryUtils.validateRect((Rectangle)selection);
        Rectangle rect = LafUtils.calculateIconedRect(selection);
        LafUtils.getSelectorIcon(selector).paintIcon(g2d, rect);
    }

    public static void drawWebIconedGripper(Graphics2D g2d, Point point) {
        LafUtils.drawWebIconedGripper(g2d, point.x, point.y);
    }

    public static void drawWebIconedGripper(Graphics2D g2d, int x, int y) {
        g2d.drawImage(gripper.getImage(), x - gripper.getIconWidth() / 2, y - gripper.getIconHeight() / 2, null);
    }

    private static Rectangle calculateIconedRect(Rectangle selection) {
        return new Rectangle(selection.x - halfButton - shadeWidth, selection.y - halfButton - shadeWidth, selection.width + halfButton * 2 + shadeWidth * 2, selection.height + halfButton * 2 + shadeWidth * 2);
    }

    private static NinePatchIcon getSelectorIcon(int selector) {
        if (selectorCache.containsKey(selector)) {
            return selectorCache.get(selector);
        }
        NinePatchIcon npi = new NinePatchIcon(LafUtils.class.getResource("icons/selection/selector" + selector + ".9.png"));
        selectorCache.put(selector, npi);
        return npi;
    }

    public static Point getTextCenterShift(FontMetrics metrics, String text) {
        return new Point(LafUtils.getTextCenterShiftX(metrics, text), LafUtils.getTextCenterShiftY(metrics));
    }

    public static int getTextCenterShiftX(FontMetrics metrics, String text) {
        return -metrics.stringWidth(text) / 2;
    }

    public static int getTextCenterShiftY(FontMetrics metrics) {
        return (metrics.getAscent() - metrics.getLeading() - metrics.getDescent()) / 2;
    }

    public static ShapeProvider getShapeProvider(Component component) {
        if (component instanceof ShapeProvider) {
            return (ShapeProvider)((Object)component);
        }
        Object ui = LafUtils.getUI(component);
        if (ui != null && ui instanceof ShapeProvider) {
            return (ShapeProvider)ui;
        }
        return null;
    }

    public static Styleable getStyleable(Component c) {
        return c != null ? (c instanceof Styleable ? (Styleable)((Object)c) : LafUtils.getStyleable(LafUtils.getUI(c))) : null;
    }

    public static Styleable getStyleable(ComponentUI ui) {
        return ui != null && ui instanceof Styleable ? (Styleable)((Object)ui) : null;
    }

    public static TexturePainter loadTexturePainter(Object source) {
        return LafUtils.loadTexturePainter(XmlUtils.loadResourceFile((Object)source));
    }

    public static TexturePainter loadTexturePainter(ResourceFile resource) {
        return new TexturePainter(XmlUtils.loadImageIcon((ResourceFile)resource));
    }

    public static boolean setupLookAndFeelSafely(Class<? extends LookAndFeel> clazz) {
        return LafUtils.setupLookAndFeelSafely(clazz.getCanonicalName());
    }

    public static boolean setupLookAndFeelSafely(String className) {
        try {
            UIManager.setLookAndFeel(className);
            return true;
        }
        catch (Throwable e) {
            Log.get().error("Unable to initialize L&F for class name: " + className, e);
            return false;
        }
    }
}

