/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shadow;

import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.shadow.AbstractShadow;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.utils.CompareUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

@XStreamAlias(value="ExpandingShadow")
public class ExpandingShadow<E extends JComponent, D extends IDecoration<E, D>, I extends ExpandingShadow<E, D, I>>
extends AbstractShadow<E, D, I> {
    protected static final Map<String, WeakReference<NinePatchIcon>> shadowCache = new HashMap<String, WeakReference<NinePatchIcon>>(4);
    protected transient String shadowKey;
    protected transient NinePatchIcon shadowImage;

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, D d, Shape shape) {
        int width = this.getWidth();
        float opacity = this.getOpacity();
        if (width > 0 && opacity > 0.0f) {
            ShadowType type = this.getType();
            if (type == ShadowType.outer) {
                Rectangle b = shape.getBounds();
                Rectangle sb = new Rectangle(b.x - width, b.y - width, b.width + width * 2, b.height + width * 2);
                this.getShadow(sb, width, opacity).paintIcon(g2d, sb.x, sb.y, sb.width, sb.height);
            } else {
                throw new RuntimeException("Inner shadow type is not supported by this shadow");
            }
        }
    }

    protected NinePatchIcon getShadow(Rectangle bounds, int width, float opacity) {
        String key = ExpandingShadow.getShadowKey(bounds, width, opacity);
        if (this.shadowImage == null || !CompareUtils.equals((Object)this.shadowKey, (Object[])new Object[]{key})) {
            this.shadowKey = key;
            this.shadowImage = ExpandingShadow.getShadeCache(bounds, width, opacity);
        }
        return this.shadowImage;
    }

    protected static String getShadowKey(Rectangle b, int width, float opacity) {
        return b.height + "," + width + "," + opacity;
    }

    protected static NinePatchIcon getShadeCache(Rectangle b, int width, float opacity) {
        String key = ExpandingShadow.getShadowKey(b, width, opacity);
        WeakReference<NinePatchIcon> reference = shadowCache.get(key);
        if (reference == null || reference.get() == null) {
            GeneralPath gp = new GeneralPath(0);
            gp.moveTo((double)b.x + (double)width * 1.45, (double)b.y + (double)width * 1.45);
            gp.lineTo((double)(b.x + b.width) - (double)width * 1.45, (double)b.y + (double)width * 1.45);
            gp.lineTo(b.x + b.width - width, b.y + b.height - width);
            gp.quadTo((double)(b.x + b.width / 2), (double)(b.y + b.height) - (double)width * 1.9, (double)(b.x + width), (double)(b.y + b.height - width));
            gp.closePath();
            BufferedImage shadowImage = ImageUtils.createShadeImage((int)b.width, (int)b.height, (Shape)gp, (int)width, (float)opacity, (boolean)false);
            int w = shadowImage.getWidth();
            int inner = width / 2;
            NinePatchIcon ninePatchIcon = NinePatchIcon.create(shadowImage);
            ninePatchIcon.addHorizontalStretch(0, width + inner, true);
            ninePatchIcon.addHorizontalStretch(width + inner + 1, w - width - inner - 1, false);
            ninePatchIcon.addHorizontalStretch(w - width - inner, w, true);
            ninePatchIcon.addVerticalStretch(0, width + inner, true);
            ninePatchIcon.addVerticalStretch(width + inner + 1, w - width - inner - 1, false);
            ninePatchIcon.addVerticalStretch(w - width - inner, w, true);
            ninePatchIcon.setMargin(width);
            shadowCache.put(key, new WeakReference<NinePatchIcon>(ninePatchIcon));
        }
        return (NinePatchIcon)shadowCache.get(key).get();
    }
}

