/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.common;

import com.alee.painter.AbstractPainter;
import com.alee.utils.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BorderPainter<E extends JComponent, U extends ComponentUI>
extends AbstractPainter<E, U> {
    protected int round;
    protected Color color;
    protected Stroke stroke;

    public BorderPainter() {
    }

    public BorderPainter(Color color) {
        this.color = color;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.repaint();
    }

    public int getStrokeWidth() {
        Stroke stroke = this.getStroke();
        return stroke != null && stroke instanceof BasicStroke ? Math.round(((BasicStroke)stroke).getLineWidth()) : 0;
    }

    @Override
    public Insets getBorders() {
        int width = this.getStrokeWidth();
        return this.i(width, width, width, width);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        if (this.stroke != null && this.color != null) {
            Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
            Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)this.stroke, (this.stroke != null ? 1 : 0) != 0);
            g2d.setPaint(this.color);
            g2d.draw(this.getBorderShape(bounds));
            GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os, (this.stroke != null ? 1 : 0) != 0);
            GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        }
    }

    protected RectangularShape getBorderShape(Rectangle bounds) {
        double shear;
        int width = this.getStrokeWidth();
        double d = shear = width == 1 ? 0.0 : (double)width / 2.0;
        if (this.round > 0) {
            return new RoundRectangle2D.Double((double)bounds.x + shear, (double)bounds.y + shear, (double)bounds.width - shear * 2.0 - 1.0, (double)bounds.height - shear * 2.0 - 1.0, this.round * 2, this.round * 2);
        }
        return new Rectangle2D.Double((double)bounds.x + shear, (double)bounds.y + shear, (double)bounds.width - shear * 2.0 - 1.0, (double)bounds.height - shear * 2.0 - 1.0);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.getStrokeWidth();
        return new Dimension(Math.max(width * 2, this.round * 2), Math.max(width * 2, this.round * 2));
    }
}

