/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter;

import com.alee.painter.Painter;
import com.alee.painter.PainterListener;
import com.alee.painter.SectionPainter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.WebBorder;
import com.alee.utils.swing.BorderMethods;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractPainter<E extends JComponent, U extends ComponentUI>
implements Painter<E, U>,
BorderMethods {
    protected final transient List<PainterListener> listeners = new ArrayList<PainterListener>(1);
    protected transient PropertyChangeListener propertyChangeListener;
    protected transient E component;
    protected transient U ui;
    protected transient boolean ltr;

    @Override
    public void install(E c, U ui) {
        this.component = c;
        this.ui = ui;
        this.updateOrientation();
        this.saveOrientation();
        this.updateBorder();
        this.installPropertyChangeListener();
    }

    @Override
    public void uninstall(E c, U ui) {
        this.uninstallPropertyChangeListener();
        this.component = null;
        this.ui = null;
    }

    @Override
    public Boolean isOpaque() {
        return null;
    }

    @Override
    public Insets getBorders() {
        return null;
    }

    protected boolean isSettingsUpdateAllowed() {
        return !this.isSectionPainter();
    }

    protected boolean isSectionPainter() {
        return this instanceof SectionPainter;
    }

    protected void installPropertyChangeListener() {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractPainter.this.propertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        ((Container)this.component).addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallPropertyChangeListener() {
        ((Component)this.component).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void propertyChange(String property, Object oldValue, Object newValue) {
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"componentOrientation"})) {
            this.orientationChange();
        }
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"border"})) {
            this.borderChange((Border)newValue);
        }
    }

    protected void orientationChange() {
        this.saveOrientation();
        if (this.isSettingsUpdateAllowed()) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void borderChange(Border border) {
        if (!SwingUtils.isUIResource(border)) {
            SwingUtils.setHonorUserBorders(this.component, true);
        }
    }

    protected void saveOrientation() {
        this.ltr = ((Component)this.component).getComponentOrientation().isLeftToRight();
    }

    public void updateOrientation() {
        if (this.isSettingsUpdateAllowed()) {
            SwingUtils.setOrientation(this.component);
        }
    }

    @Override
    public void updateBorder() {
        Border old;
        Insets border;
        if (!(!this.isSettingsUpdateAllowed() || (border = this.getCompleteBorder()) == null || (old = ((JComponent)this.component).getBorder()) instanceof WebBorder && CompareUtils.equals((Object)((WebBorder)old).getBorderInsets(), (Object[])new Object[]{border}))) {
            ((JComponent)this.component).setBorder(new WebBorder(border));
        }
    }

    public Insets getCompleteBorder() {
        if (this.component != null && !SwingUtils.isPreserveBorders(this.component)) {
            Insets padding;
            Insets borders;
            Insets margin;
            Insets border = this.i(0, 0, 0, 0);
            if (!this.isSectionPainter() && (margin = LafUtils.getMargin(this.component)) != null) {
                border.top += margin.top;
                border.left = border.left + (this.ltr ? margin.left : margin.right);
                border.bottom += margin.bottom;
                border.right = border.right + (this.ltr ? margin.right : margin.left);
            }
            if ((borders = this.getBorders()) != null) {
                border.top += borders.top;
                border.left = border.left + (this.ltr ? borders.left : borders.right);
                border.bottom += borders.bottom;
                border.right = border.right + (this.ltr ? borders.right : borders.left);
            }
            if (!this.isSectionPainter() && (padding = LafUtils.getPadding(this.component)) != null) {
                border.top += padding.top;
                border.left = border.left + (this.ltr ? padding.left : padding.right);
                border.bottom += padding.bottom;
                border.right = border.right + (this.ltr ? padding.right : padding.left);
            }
            return border;
        }
        return null;
    }

    public void repaint() {
        if (this.isSettingsUpdateAllowed() && this.component != null && ((Component)this.component).isShowing()) {
            for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
                listener.repaint();
            }
        }
    }

    public void repaint(Rectangle bounds) {
        this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void repaint(int x, int y, int width, int height) {
        if (this.isSettingsUpdateAllowed() && ((Component)this.component).isShowing()) {
            for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
                listener.repaint(x, y, width, height);
            }
        }
    }

    public void revalidate() {
        if (this.isSettingsUpdateAllowed()) {
            this.updateBorder();
            for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
                listener.revalidate();
            }
        }
    }

    public void updateOpacity() {
        if (this.isSettingsUpdateAllowed()) {
            for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
                listener.updateOpacity();
            }
        }
    }

    public void updateAll() {
        if (this.isSettingsUpdateAllowed()) {
            this.updateBorder();
            for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
                listener.updateOpacity();
                listener.revalidate();
                if (!((Component)this.component).isShowing()) continue;
                listener.repaint();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets b = this.getCompleteBorder();
        return b != null ? new Dimension(b.left + b.right, b.top + b.bottom) : new Dimension();
    }

    @Override
    public void addPainterListener(PainterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePainterListener(PainterListener listener) {
        this.listeners.remove(listener);
    }

    protected Point p(int x, int y) {
        return new Point(x, y);
    }

    protected Insets i(int top, int left, int bottom, int right) {
        return new Insets(top, left, bottom, right);
    }

    protected Insets i(Insets insets, int top, int left, int bottom, int right) {
        return insets != null ? new Insets(insets.top + top, insets.left + left, insets.bottom + bottom, insets.right + right) : new Insets(top, left, bottom, right);
    }

    protected Insets i(Insets i1, Insets i2) {
        return i1 != null && i2 != null ? new Insets(i1.top + i2.top, i1.left + i2.left, i1.bottom + i2.bottom, i1.right + i2.right) : (i1 != null ? i1 : i2);
    }

    protected Rectangle b(Rectangle bounds, Insets limit) {
        return SwingUtils.shrink(bounds, limit);
    }
}

