/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.extended.checkbox.MixedIcon;
import com.alee.extended.statusbar.WebMemoryBarBackground;
import com.alee.laf.checkbox.CheckIcon;
import com.alee.laf.radiobutton.RadioIcon;
import com.alee.laf.separator.SeparatorLine;
import com.alee.laf.separator.SeparatorLines;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleData;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleableComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfo;
import com.alee.painter.Painter;
import com.alee.painter.common.TextureType;
import com.alee.painter.decoration.AbstractDecoration;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.painter.decoration.background.AlphaLayerBackground;
import com.alee.painter.decoration.background.ColorBackground;
import com.alee.painter.decoration.background.GradientBackground;
import com.alee.painter.decoration.background.GradientColor;
import com.alee.painter.decoration.background.GradientType;
import com.alee.painter.decoration.background.PresetTextureBackground;
import com.alee.painter.decoration.border.AbstractBorder;
import com.alee.painter.decoration.border.LineBorder;
import com.alee.painter.decoration.shadow.AbstractShadow;
import com.alee.painter.decoration.shadow.ExpandingShadow;
import com.alee.painter.decoration.shadow.WebShadow;
import com.alee.painter.decoration.shape.ArrowShape;
import com.alee.painter.decoration.shape.EllipseShape;
import com.alee.painter.decoration.shape.WebShape;
import com.alee.skin.web.WebSkin;
import com.alee.utils.CompareUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;

public final class StyleManager {
    private static final Map<JComponent, StyleData> styleData = new WeakHashMap<JComponent, StyleData>();
    private static Class<? extends Skin> defaultSkinClass = null;
    private static Skin currentSkin = null;
    private static boolean strictStyleChecks = true;
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(SkinInfo.class);
            XmlUtils.processAnnotations(ComponentStyle.class);
            XmlUtils.processAnnotations(NinePatchIcon.class);
            XmlUtils.processAnnotations(AbstractDecoration.class);
            XmlUtils.processAnnotations(WebDecoration.class);
            XmlUtils.processAnnotations(AbstractShadow.class);
            XmlUtils.processAnnotations(WebShape.class);
            XmlUtils.processAnnotations(EllipseShape.class);
            XmlUtils.processAnnotations(ArrowShape.class);
            XmlUtils.processAnnotations(WebShadow.class);
            XmlUtils.processAnnotations(ExpandingShadow.class);
            XmlUtils.processAnnotations(AbstractBorder.class);
            XmlUtils.processAnnotations(LineBorder.class);
            XmlUtils.processAnnotations(AbstractBackground.class);
            XmlUtils.processAnnotations(ColorBackground.class);
            XmlUtils.processAnnotations(GradientBackground.class);
            XmlUtils.processAnnotations(PresetTextureBackground.class);
            XmlUtils.processAnnotations(AlphaLayerBackground.class);
            XmlUtils.processAnnotations(TextureType.class);
            XmlUtils.processAnnotations(GradientType.class);
            XmlUtils.processAnnotations(GradientColor.class);
            XmlUtils.processAnnotations(SeparatorLines.class);
            XmlUtils.processAnnotations(SeparatorLine.class);
            XmlUtils.processAnnotations(CheckIcon.class);
            XmlUtils.processAnnotations(RadioIcon.class);
            XmlUtils.processAnnotations(MixedIcon.class);
            XmlUtils.processAnnotations(WebMemoryBarBackground.class);
            StyleManager.setSkin(StyleManager.getDefaultSkin());
        }
    }

    private static void checkInitialization() {
        if (!initialized) {
            throw new StyleException("StyleManager must be initialized");
        }
    }

    public static boolean isStrictStyleChecks() {
        return strictStyleChecks;
    }

    public static void setStrictStyleChecks(boolean strict) {
        strictStyleChecks = strict;
    }

    public static Class<? extends Skin> getDefaultSkin() {
        return defaultSkinClass != null ? defaultSkinClass : WebSkin.class;
    }

    public static Class<? extends Skin> setDefaultSkin(String skinClassName) {
        return StyleManager.setDefaultSkin(ReflectUtils.getClassSafely((String)skinClassName));
    }

    public static Class<? extends Skin> setDefaultSkin(Class<? extends Skin> skinClass) {
        Class<? extends Skin> oldSkin = defaultSkinClass;
        defaultSkinClass = skinClass;
        return oldSkin;
    }

    public static Skin getSkin() {
        return currentSkin;
    }

    public static Skin setSkin(String skinClassName) {
        return StyleManager.setSkin(ReflectUtils.getClassSafely((String)skinClassName));
    }

    public static Skin setSkin(Class skinClass) {
        return StyleManager.setSkin(StyleManager.createSkin(skinClass));
    }

    public static synchronized Skin setSkin(Skin skin) {
        StyleManager.checkInitialization();
        StyleManager.checkSupport(skin);
        Skin previousSkin = currentSkin;
        currentSkin = skin;
        HashMap skins = MapUtils.copyMap(styleData);
        for (Map.Entry entry : skins.entrySet()) {
            JComponent component = (JComponent)entry.getKey();
            StyleData data = StyleManager.getData(component);
            if (data.isPinnedSkin() || data.getSkin() != previousSkin) continue;
            data.applySkin(skin, false);
        }
        return previousSkin;
    }

    public static StyleId getStyleId(JComponent component) {
        StyleData data = StyleManager.getData(component);
        return data.getStyleId() != null ? data.getStyleId() : StyleId.getDefault(component);
    }

    public static StyleId setStyleId(JComponent component, StyleId id) {
        StyleId styleId;
        StyleData data = StyleManager.getData(component);
        StyleId old = data.getStyleId();
        StyleId styleId2 = styleId = id != null ? id : StyleId.getDefault(component);
        if (!CompareUtils.equals((Object)old, (Object[])new Object[]{styleId})) {
            JComponent parent;
            JComponent oldParent;
            data.setStyleId(styleId);
            if (old != null && (oldParent = old.getParent()) != null) {
                StyleManager.getData(oldParent).removeChild(component);
            }
            if ((parent = styleId.getParent()) != null) {
                StyleManager.getData(parent).addChild(component);
            }
        }
        return old;
    }

    public static StyleId restoreStyleId(JComponent component) {
        StyleId defaultStyleId = StyleableComponent.get(component).getDefaultStyleId();
        return StyleManager.setStyleId(component, defaultStyleId);
    }

    public static Skin installSkin(JComponent component) {
        return StyleManager.getData(component).applySkin(StyleManager.getSkin(), false);
    }

    public static void updateSkin(JComponent component) {
        StyleManager.getData(component).updateSkin();
    }

    public static Skin uninstallSkin(JComponent component) {
        return StyleManager.getData(component).removeSkin();
    }

    public static Skin getSkin(JComponent component) {
        return StyleManager.getData(component).getSkin();
    }

    public static Skin setSkin(JComponent component, Skin skin) {
        return StyleManager.setSkin(component, skin, false);
    }

    public static Skin setSkin(JComponent component, Skin skin, boolean recursively) {
        StyleData data = StyleManager.getData(component);
        Skin previousSkin = data.applySkin(skin, !recursively);
        data.setPinnedSkin(true);
        if (recursively) {
            for (int i = 0; i < component.getComponentCount(); ++i) {
                Component child = component.getComponent(i);
                if (!(child instanceof JComponent)) continue;
                StyleManager.setSkin((JComponent)child, skin, recursively);
            }
        }
        return previousSkin;
    }

    public static Skin restoreSkin(JComponent component) {
        StyleData data = StyleManager.getData(component);
        Skin skin = data.getSkin();
        Skin globalSkin = StyleManager.getSkin();
        if (globalSkin == skin) {
            data.applySkin(globalSkin, true);
            return globalSkin;
        }
        return skin;
    }

    public static void addStyleListener(JComponent component, StyleListener listener) {
        StyleManager.getData(component).addStyleListener(listener);
    }

    public static void removeStyleListener(JComponent component, StyleListener listener) {
        StyleManager.getData(component).removeStyleListener(listener);
    }

    public static Map<String, Painter> getCustomPainters(JComponent component) {
        return StyleManager.getData(component).getPainters();
    }

    public static Painter getCustomPainter(JComponent component) {
        return StyleManager.getCustomPainter(component, "painter");
    }

    public static Painter getCustomPainter(JComponent component, String id) {
        Map<String, Painter> customPainters = StyleManager.getCustomPainters(component);
        return customPainters != null ? customPainters.get(id) : null;
    }

    public static <T extends Painter> T setCustomPainter(JComponent component, T painter) {
        return StyleManager.setCustomPainter(component, "painter", painter);
    }

    public static <T extends Painter> T setCustomPainter(JComponent component, String id, T painter) {
        StyleData data = StyleManager.getData(component);
        Map<String, Painter> painters = data.getPainters();
        if (painters == null) {
            painters = new HashMap<String, Painter>(1);
            data.setPainters(painters);
        }
        Painter oldValue = painters.put(id, painter);
        StyleManager.installSkin(component);
        return (T)oldValue;
    }

    public static boolean restoreDefaultPainters(JComponent component) {
        Map<String, Painter> painters = StyleManager.getData(component).getPainters();
        if (painters != null && painters.size() > 0) {
            painters.clear();
            StyleManager.installSkin(component);
            return true;
        }
        return false;
    }

    private static StyleData getData(JComponent component) {
        StyleManager.checkInitialization();
        StyleManager.checkSupport(component);
        StyleData data = styleData.get(component);
        if (data == null) {
            data = new StyleData(component);
            styleData.put(component, data);
        }
        return data;
    }

    private static void checkSupport(JComponent component) {
        if (component == null) {
            throw new StyleException("Component is not specified");
        }
        if (!StyleableComponent.isSupported(component)) {
            throw new StyleException("Component \"" + component + "\" is not supported");
        }
    }

    private static void checkSupport(Skin skin) {
        if (skin == null) {
            throw new StyleException("Skin is not provided or failed to load");
        }
        if (!skin.isSupported()) {
            throw new StyleException("Skin \"" + skin.getTitle() + "\" is not supported in this system");
        }
    }

    private static Skin createSkin(Class skinClass) {
        try {
            return (Skin)ReflectUtils.createInstance((Class)skinClass, (Object[])new Object[0]);
        }
        catch (Throwable e) {
            throw new StyleException("Unable to initialize skin from its class", e);
        }
    }
}

