/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.icon;

import com.alee.managers.icon.IconException;
import com.alee.managers.icon.IconInfo;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IconManager {
    private static Map<String, IconInfo> lazyIcons;
    private static Map<String, WeakReference<Icon>> cache;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            lazyIcons = new HashMap<String, IconInfo>(100);
            cache = new HashMap<String, WeakReference<Icon>>(30);
        }
    }

    public static void add(IconInfo icon) {
        lazyIcons.put(icon.getId(), icon);
        cache.remove(icon.getId());
    }

    public static Icon get(String id) {
        Icon icon;
        WeakReference<Icon> reference = cache.get(id);
        if (reference != null && (icon = (Icon)reference.get()) != null) {
            return icon;
        }
        IconInfo iconInfo = lazyIcons.get(id);
        if (iconInfo != null) {
            ImageIcon icon2;
            Class<? extends Icon> type = iconInfo.getType();
            if (type == ImageIcon.class) {
                icon2 = iconInfo.getNearClass() != null ? new ImageIcon(iconInfo.getNearClass().getResource(iconInfo.getPath())) : new ImageIcon(iconInfo.getPath());
            } else {
                throw new IconException("Unknown icon class type: " + type);
            }
            cache.put(id, new WeakReference<ImageIcon>(icon2));
            return icon2;
        }
        throw new IconException("Icon is not provided for ID: " + id);
    }

    static {
        initialized = false;
    }
}

