/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag;

import com.alee.managers.drag.DragViewHandler;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public abstract class SimpleDragViewHandler<T>
implements DragViewHandler<T> {
    protected static final Insets margin = new Insets(6, 6, 6, 6);
    protected static final int textSideSpacing = 3;

    protected FontMetrics getFontMetrics(T object) {
        return SwingUtils.getDefaultLabelFontMetrics();
    }

    protected abstract Icon getIcon(T var1);

    protected abstract Color getForeground(T var1);

    protected abstract String getText(T var1);

    @Override
    public BufferedImage getView(T object, DragSourceDragEvent event) {
        Icon icon = this.getIcon(object);
        Color foreground = this.getForeground(object);
        String title = this.getText(object);
        FontMetrics fm = this.getFontMetrics(object);
        int tm = SimpleDragViewHandler.margin.left + (icon != null ? icon.getIconWidth() + 4 : 3);
        int em = SimpleDragViewHandler.margin.right + 3;
        int w = tm + fm.stringWidth(title) + em;
        int h = SimpleDragViewHandler.margin.top + Math.max(icon != null ? icon.getIconHeight() : 0, fm.getHeight()) + SimpleDragViewHandler.margin.bottom;
        BufferedImage image = ImageUtils.createCompatibleImage((int)w, (int)h, (int)3);
        Graphics2D g2d = image.createGraphics();
        GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(0.8f));
        GraphicsUtils.setupFont((Graphics)g2d, (Font)fm.getFont());
        GraphicsUtils.setupSystemTextHints((Graphics2D)g2d);
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, w, h);
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.drawRect(0, 0, w - 1, h - 1);
        if (icon != null) {
            icon.paintIcon(null, g2d, SimpleDragViewHandler.margin.left, SimpleDragViewHandler.margin.top);
        }
        g2d.setPaint(foreground != null ? foreground : Color.BLACK);
        g2d.drawString(title, tm, SimpleDragViewHandler.margin.top + (h - SimpleDragViewHandler.margin.top - SimpleDragViewHandler.margin.bottom) / 2 + LafUtils.getTextCenterShiftY(fm));
        g2d.dispose();
        return image;
    }

    @Override
    public Point getViewRelativeLocation(T document, DragSourceDragEvent event) {
        return new Point(25, 5);
    }

    @Override
    public void dragEnded(T object, DragSourceDropEvent event) {
    }
}

