/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.AlternateTreeRowPainter;
import com.alee.laf.tree.ITreeDropLocationPainter;
import com.alee.laf.tree.ITreeNodePainter;
import com.alee.laf.tree.ITreePainter;
import com.alee.laf.tree.ITreeRowPainter;
import com.alee.laf.tree.ITreeSelectorPainter;
import com.alee.laf.tree.TreeDropLocationPainter;
import com.alee.laf.tree.TreeNodePainter;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.TreeSelectorPainter;
import com.alee.laf.tree.WebTreeUI;
import com.alee.managers.style.Bounds;
import com.alee.painter.DefaultPainter;
import com.alee.painter.PainterSupport;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreePainter<E extends JTree, U extends WebTreeUI, D extends IDecoration<E, D>>
extends AbstractDecorationPainter<E, U, D>
implements ITreePainter<E, U> {
    protected boolean paintLines;
    protected boolean dashedLines;
    protected Color linesColor;
    @DefaultPainter(value=AlternateTreeRowPainter.class)
    protected ITreeRowPainter rowPainter;
    @DefaultPainter(value=TreeNodePainter.class)
    protected ITreeNodePainter hoverPainter;
    @DefaultPainter(value=TreeNodePainter.class)
    protected ITreeNodePainter selectionPainter;
    @DefaultPainter(value=TreeDropLocationPainter.class)
    protected ITreeDropLocationPainter dropLocationPainter;
    @DefaultPainter(value=TreeSelectorPainter.class)
    protected ITreeSelectorPainter selectorPainter;
    protected TreeSelectionListener treeSelectionListener;
    protected TreeExpansionListener treeExpansionListener;
    protected MouseAdapter mouseAdapter;
    protected List<Integer> initialSelection = new ArrayList<Integer>();
    protected Point selectionStart = null;
    protected Point selectionEnd = null;
    protected TreePath draggablePath = null;
    protected int totalChildIndent;
    protected int depthOffset;
    protected TreeModel treeModel;
    protected AbstractLayoutCache treeState;
    protected Hashtable<TreePath, Boolean> paintingCache;
    protected CellRendererPane rendererPane;
    protected TreeCellRenderer currentCellRenderer;
    protected int editingRow = -1;
    protected int lastSelectionRow = -1;

    @Override
    public void install(E c, U ui) {
        super.install(c, ui);
        this.rowPainter = PainterSupport.installSectionPainter(this, this.rowPainter, null, c, ui);
        this.hoverPainter = PainterSupport.installSectionPainter(this, this.hoverPainter, null, c, ui);
        this.selectionPainter = PainterSupport.installSectionPainter(this, this.selectionPainter, null, c, ui);
        this.dropLocationPainter = PainterSupport.installSectionPainter(this, this.dropLocationPainter, null, c, ui);
        this.selectorPainter = PainterSupport.installSectionPainter(this, this.selectorPainter, null, c, ui);
        this.treeSelectionListener = new TreeSelectionListener((WebTreeUI)ui){
            final /* synthetic */ WebTreeUI val$ui;
            {
                this.val$ui = webTreeUI;
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePainter.this.repaintSelection();
                if (this.val$ui.isExpandSelected() && ((JTree)TreePainter.this.component).getSelectionCount() > 0) {
                    ((JTree)TreePainter.this.component).expandPath(((JTree)TreePainter.this.component).getSelectionPath());
                }
            }
        };
        ((JTree)this.component).addTreeSelectionListener(this.treeSelectionListener);
        this.treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePainter.this.repaintSelection();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreePainter.this.repaintSelection();
            }
        };
        ((JTree)this.component).addTreeExpansionListener(this.treeExpansionListener);
        this.mouseAdapter = new MouseAdapter((WebTreeUI)ui){
            final /* synthetic */ WebTreeUI val$ui;
            {
                this.val$ui = webTreeUI;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!(!SwingUtilities.isLeftMouseButton(e) || (SwingUtils.isCtrl(e) || ((JTree)TreePainter.this.component).getDragEnabled() && ((JTree)TreePainter.this.component).getTransferHandler() != null) && this.val$ui.getRowForPoint(e.getPoint(), false) != -1)) {
                    TreePath path;
                    if (TreePainter.this.isSelectorAvailable()) {
                        TreePath path2 = this.val$ui.getClosestPathForLocation((JTree)TreePainter.this.component, e.getX(), e.getY());
                        if (path2 == null || !TreePainter.this.isLocationInExpandControl(path2, e.getX(), e.getY()) && !this.val$ui.isLocationInCheckBoxControl(path2, e.getX(), e.getY())) {
                            int rowForPath = this.val$ui.getRowForPath((JTree)TreePainter.this.component, path2);
                            if (TreePainter.this.isDragAvailable() && rowForPath != -1 && this.val$ui.getRowBounds(rowForPath).contains(e.getX(), e.getY()) && ((JTree)TreePainter.this.component).isRowSelected(rowForPath)) {
                                TreePainter.this.draggablePath = path2;
                            } else {
                                TreePainter.this.selectionEnd = TreePainter.this.selectionStart = e.getPoint();
                                TreePainter.this.initialSelection = this.getSelectedRows();
                                this.validateSelection(e);
                                this.repaintSelector();
                            }
                        }
                    } else if (TreePainter.this.isFullLineSelection() && (path = this.val$ui.getClosestPathForLocation((JTree)TreePainter.this.component, e.getX(), e.getY())) != null && !TreePainter.this.isLocationInExpandControl(path, e.getX(), e.getY()) && !this.val$ui.isLocationInCheckBoxControl(path, e.getX(), e.getY())) {
                        if (((JTree)TreePainter.this.component).getSelectionModel().getSelectionMode() == 1) {
                            ((JTree)TreePainter.this.component).setSelectionRow(this.val$ui.getRowForPoint(e.getPoint(), true));
                        }
                        int rowForPath = this.val$ui.getRowForPath((JTree)TreePainter.this.component, path);
                        if (TreePainter.this.isDragAvailable() && this.val$ui.getRowBounds(rowForPath).contains(e.getX(), e.getY()) && ((JTree)TreePainter.this.component).isRowSelected(rowForPath)) {
                            TreePainter.this.draggablePath = path;
                        }
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TreePainter.this.draggablePath != null) {
                    TransferHandler transferHandler = ((JTree)TreePainter.this.component).getTransferHandler();
                    transferHandler.exportAsDrag(TreePainter.this.component, e, transferHandler.getSourceActions(TreePainter.this.component));
                    TreePainter.this.draggablePath = null;
                }
                if (TreePainter.this.isSelectorAvailable() && TreePainter.this.selectionStart != null) {
                    TreePainter.this.selectionEnd = e.getPoint();
                    this.validateSelection(e);
                    this.repaintSelector();
                    if (!((JTree)TreePainter.this.component).getVisibleRect().contains(e.getPoint())) {
                        ((JTree)TreePainter.this.component).scrollRectToVisible(new Rectangle(e.getPoint(), new Dimension(0, 0)));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TreePainter.this.draggablePath != null) {
                    TreePainter.this.draggablePath = null;
                }
                if (TreePainter.this.isSelectorAvailable() && TreePainter.this.selectionStart != null) {
                    TreePainter.this.selectionStart = null;
                    TreePainter.this.selectionEnd = null;
                    this.repaintSelector();
                }
            }

            private void validateSelection(MouseEvent e) {
                Rectangle selection = GeometryUtils.getContainingRect((Point[])new Point[]{TreePainter.this.selectionStart, TreePainter.this.selectionEnd});
                ArrayList<Integer> newSelection = new ArrayList<Integer>();
                if (SwingUtils.isShift(e)) {
                    for (int row = 0; row < ((JTree)TreePainter.this.component).getRowCount(); ++row) {
                        if (!this.val$ui.getRowBounds(row).intersects(selection) || TreePainter.this.initialSelection.contains(row)) continue;
                        newSelection.add(row);
                    }
                    for (int row : TreePainter.this.initialSelection) {
                        newSelection.add(row);
                    }
                } else if (SwingUtils.isCtrl(e)) {
                    ArrayList<Integer> excludedRows = new ArrayList<Integer>();
                    for (int row = 0; row < ((JTree)TreePainter.this.component).getRowCount(); ++row) {
                        if (!this.val$ui.getRowBounds(row).intersects(selection)) continue;
                        if (TreePainter.this.initialSelection.contains(row)) {
                            excludedRows.add(row);
                            continue;
                        }
                        newSelection.add(row);
                    }
                    for (int row : TreePainter.this.initialSelection) {
                        if (excludedRows.contains(row)) continue;
                        newSelection.add(row);
                    }
                } else {
                    for (int row = 0; row < ((JTree)TreePainter.this.component).getRowCount(); ++row) {
                        if (!this.val$ui.getRowBounds(row).intersects(selection)) continue;
                        newSelection.add(row);
                    }
                }
                if (!CollectionUtils.equals(this.getSelectedRows(), newSelection)) {
                    if (newSelection.size() > 0) {
                        ((JTree)TreePainter.this.component).setSelectionRows(CollectionUtils.toArray(newSelection));
                    } else {
                        ((JTree)TreePainter.this.component).clearSelection();
                    }
                }
            }

            private List<Integer> getSelectedRows() {
                ArrayList<Integer> selection = new ArrayList<Integer>();
                int[] selectionRows = ((JTree)TreePainter.this.component).getSelectionRows();
                if (selectionRows != null) {
                    for (int row : selectionRows) {
                        selection.add(row);
                    }
                }
                return selection;
            }

            private void repaintSelector() {
                ((JTree)TreePainter.this.component).repaint(((JTree)TreePainter.this.component).getVisibleRect());
            }
        };
        ((JTree)this.component).addMouseListener(this.mouseAdapter);
        ((JTree)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstall(E c, U ui) {
        ((JTree)this.component).removeTreeSelectionListener(this.treeSelectionListener);
        this.treeSelectionListener = null;
        ((JTree)this.component).removeTreeExpansionListener(this.treeExpansionListener);
        this.treeExpansionListener = null;
        ((JTree)this.component).removeMouseListener(this.mouseAdapter);
        ((JTree)this.component).removeMouseMotionListener(this.mouseAdapter);
        this.mouseAdapter = null;
        this.selectorPainter = PainterSupport.uninstallSectionPainter(this.selectorPainter, c, ui);
        this.dropLocationPainter = PainterSupport.uninstallSectionPainter(this.dropLocationPainter, c, ui);
        this.selectionPainter = PainterSupport.uninstallSectionPainter(this.selectionPainter, c, ui);
        this.hoverPainter = PainterSupport.uninstallSectionPainter(this.hoverPainter, c, ui);
        this.rowPainter = PainterSupport.uninstallSectionPainter(this.rowPainter, c, ui);
        super.uninstall(c, ui);
    }

    @Override
    protected void propertyChange(String property, Object oldValue, Object newValue) {
        super.propertyChange(property, oldValue, newValue);
        if (CompareUtils.equals((Object)property, (Object[])new Object[]{"dropLocation"}) && this.dropLocationPainter != null) {
            JTree.DropLocation newLocation;
            JTree.DropLocation oldLocation = (JTree.DropLocation)oldValue;
            if (oldLocation != null) {
                ((JTree)this.component).repaint(this.dropLocationPainter.getDropViewBounds(oldLocation));
            }
            if ((newLocation = (JTree.DropLocation)newValue) != null) {
                ((JTree)this.component).repaint(this.dropLocationPainter.getDropViewBounds(newLocation));
            }
        }
    }

    @Override
    protected List<SectionPainter<E, U>> getSectionPainters() {
        return this.asList(this.rowPainter, this.selectionPainter, this.hoverPainter);
    }

    @Override
    protected void paintContent(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        this.treeState = ((WebTreeUI)ui).getTreeState();
        if (this.treeState == null) {
            return;
        }
        this.treeModel = ((JTree)this.component).getModel();
        this.totalChildIndent = ((BasicTreeUI)ui).getLeftChildIndent() + ((BasicTreeUI)ui).getRightChildIndent();
        this.rendererPane = ((WebTreeUI)ui).getCellRendererPane();
        this.lastSelectionRow = ((JTree)this.component).getLeadSelectionRow();
        TreePath editingPath = ((JTree)this.component).getEditingPath();
        this.editingRow = editingPath != null ? ((JTree)this.component).getRowForPath(editingPath) : -1;
        this.updateDepthOffset();
        this.paintBackground(g2d);
        this.paintHoverNodeBackground(g2d);
        this.paintSelectedNodesBackground(g2d);
        this.paintTree(g2d);
        this.paintDropLocation(g2d, bounds, c, ui);
        this.paintMultiselector(g2d);
        this.treeModel = null;
        this.treeState = null;
        this.paintingCache = null;
        this.rendererPane = null;
    }

    protected void paintBackground(Graphics2D g2d) {
        if (this.rowPainter != null) {
            Rectangle paintBounds = g2d.getClipBounds();
            TreePath initialPath = ((WebTreeUI)this.ui).getClosestPathForLocation((JTree)this.component, 0, paintBounds.y);
            Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            if (initialPath != null && paintingEnumerator != null) {
                TreePath path;
                Insets insets = ((JTree)this.component).getInsets();
                int endY = paintBounds.y + paintBounds.height;
                Rectangle boundsBuffer = new Rectangle();
                int row = this.treeState.getRowForPath(initialPath);
                while (paintingEnumerator.hasMoreElements() && (path = paintingEnumerator.nextElement()) != null) {
                    Rectangle bounds = this.getPathBounds(path, insets, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    this.rowPainter.prepareToPaint(row);
                    Rectangle rowBounds = ((WebTreeUI)this.ui).getFullRowBounds(row);
                    Insets padding = ((WebTreeUI)this.ui).getPadding();
                    if (padding != null) {
                        rowBounds.x -= padding.left;
                        rowBounds.width += padding.left + padding.right;
                    }
                    this.rowPainter.paint(g2d, rowBounds, this.component, this.ui);
                    if (bounds.y + bounds.height >= endY) break;
                    ++row;
                }
            }
        }
    }

    @Override
    public void prepareToPaint(Hashtable<TreePath, Boolean> paintingCache, TreeCellRenderer currentCellRenderer) {
        this.paintingCache = paintingCache;
        this.currentCellRenderer = currentCellRenderer;
    }

    protected void paintCentered(Component c, Graphics2D g2d, Icon icon, int x, int y) {
        icon.paintIcon(c, g2d, this.findCenteredX(x, icon.getIconWidth()), y - icon.getIconHeight() / 2);
    }

    protected int findCenteredX(int x, int iconWidth) {
        return this.ltr ? x - 2 - (int)Math.ceil((double)iconWidth / 2.0) : x - 1 - (int)Math.floor((double)iconWidth / 2.0);
    }

    @Override
    public boolean isHoverDecorationSupported() {
        return this.hoverPainter != null && this.component != null && ((JTree)this.component).isEnabled();
    }

    protected void paintHoverNodeBackground(Graphics2D g2d) {
        int hoverRow;
        if (this.isHoverDecorationSupported() && (hoverRow = ((WebTreeUI)this.ui).getHoverRow()) != -1 && !((JTree)this.component).isRowSelected(hoverRow)) {
            Rectangle r;
            Rectangle rectangle = r = this.isFullLineSelection() ? ((WebTreeUI)this.ui).getFullRowBounds(hoverRow) : ((JTree)this.component).getRowBounds(hoverRow);
            if (r != null) {
                this.hoverPainter.paint(g2d, r, this.component, this.ui);
            }
        }
    }

    protected void paintSelectedNodesBackground(Graphics2D g2d) {
        if (this.selectionPainter != null && ((JTree)this.component).getSelectionCount() > 0 && ((WebTreeUI)this.ui).getSelectionStyle() != TreeSelectionStyle.none) {
            List<Rectangle> selections = this.getSelectionRects();
            for (Rectangle rect : selections) {
                this.selectionPainter.paint(g2d, rect, this.component, this.ui);
            }
        }
    }

    protected List<Rectangle> getSelectionRects() {
        if (((WebTreeUI)this.ui).getSelectionStyle() == TreeSelectionStyle.none) {
            return Collections.emptyList();
        }
        int[] indices = ((JTree)this.component).getSelectionRows();
        if (indices == null || indices.length == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(indices);
        ArrayList<Rectangle> selections = new ArrayList<Rectangle>(indices.length);
        Insets insets = ((JTree)this.component).getInsets();
        Rectangle maxRect = null;
        int lastRow = -1;
        for (int index : indices) {
            if (((WebTreeUI)this.ui).getSelectionStyle() == TreeSelectionStyle.single) {
                selections.add(((JTree)this.component).getRowBounds(index));
                continue;
            }
            if (lastRow != -1 && lastRow + 1 != index) {
                selections.add(maxRect);
                maxRect = null;
                lastRow = -1;
            }
            if (lastRow != -1 && lastRow + 1 != index) continue;
            Rectangle b = ((JTree)this.component).getRowBounds(index);
            if (this.isFullLineSelection()) {
                b.x = insets.left;
                b.width = ((JTree)this.component).getWidth() - insets.left - insets.right;
            }
            maxRect = lastRow == -1 ? b : GeometryUtils.getContainingRect((Rectangle)maxRect, (Rectangle)b);
            lastRow = index;
        }
        if (maxRect != null) {
            selections.add(maxRect);
        }
        return selections;
    }

    protected void repaintSelection() {
        if (((JTree)this.component).getSelectionCount() > 0) {
            for (Rectangle rect : this.getSelectionRects()) {
                ((JTree)this.component).repaint(rect);
            }
        }
    }

    protected void paintTree(Graphics2D g2d) {
        Rectangle paintBounds = g2d.getClipBounds();
        Insets insets = ((JTree)this.component).getInsets();
        TreePath initialPath = ((WebTreeUI)this.ui).getClosestPathForLocation((JTree)this.component, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        int row = this.treeState.getRowForPath(initialPath);
        this.paintingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            TreePath path;
            TreePath parentPath = initialPath;
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g2d, paintBounds, insets, parentPath);
                this.paintingCache.put(parentPath, Boolean.TRUE);
            }
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            while (paintingEnumerator.hasMoreElements() && (path = paintingEnumerator.nextElement()) != null) {
                boolean isExpanded;
                boolean hasBeenExpanded;
                boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                if (isLeaf) {
                    hasBeenExpanded = false;
                    isExpanded = false;
                } else {
                    isExpanded = this.treeState.getExpandedState(path);
                    hasBeenExpanded = ((JTree)this.component).hasBeenExpanded(path);
                }
                Rectangle bounds = this.getPathBounds(path, insets, boundsBuffer);
                if (bounds == null) {
                    return;
                }
                parentPath = path.getParentPath();
                if (parentPath != null) {
                    if (this.paintingCache.get(parentPath) == null) {
                        this.paintVerticalPartOfLeg(g2d, paintBounds, insets, parentPath);
                        this.paintingCache.put(parentPath, Boolean.TRUE);
                    }
                    this.paintHorizontalPartOfLeg(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                } else if (rootVisible && row == 0) {
                    this.paintHorizontalPartOfLeg(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
                if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                    this.paintExpandControl(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                }
                this.paintRow(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                if (bounds.y + bounds.height >= endY) break;
                ++row;
            }
        }
        this.rendererPane.removeAll();
    }

    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (path != null && !((JTree)this.component).getModel().isLeaf(path.getLastPathComponent())) {
            int boxWidth = ((WebTreeUI)this.ui).getExpandedIcon() != null ? ((WebTreeUI)this.ui).getExpandedIcon().getIconWidth() : 8;
            Insets i = ((JTree)this.component).getInsets();
            int boxLeftX = this.getRowX(((JTree)this.component).getRowForPath(path), path.getPathCount() - 1);
            boxLeftX = this.ltr ? boxLeftX + i.left - ((WebTreeUI)this.ui).getRightChildIndent() + 1 : ((JTree)this.component).getWidth() - boxLeftX - i.right + ((WebTreeUI)this.ui).getRightChildIndent() - 1;
            boxLeftX = this.findCenteredX(boxLeftX, boxWidth);
            return mouseX >= boxLeftX && mouseX < boxLeftX + boxWidth;
        }
        return false;
    }

    protected void paintExpandControl(Graphics2D g2d, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Object value = path.getLastPathComponent();
        if (!(isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0)) {
            int middleXOfKnob = this.ltr ? bounds.x - ((WebTreeUI)this.ui).getRightChildIndent() + 1 : bounds.x + bounds.width + ((WebTreeUI)this.ui).getRightChildIndent() - 1;
            int middleYOfKnob = bounds.y + bounds.height / 2;
            if (isExpanded) {
                Icon expandedIcon = ((WebTreeUI)this.ui).getExpandedIcon();
                if (expandedIcon != null) {
                    this.paintCentered(this.component, g2d, expandedIcon, middleXOfKnob, middleYOfKnob);
                }
            } else {
                Icon collapsedIcon = ((WebTreeUI)this.ui).getCollapsedIcon();
                if (collapsedIcon != null) {
                    this.paintCentered(this.component, g2d, collapsedIcon, middleXOfKnob, middleYOfKnob);
                }
            }
        }
    }

    protected void paintRow(Graphics2D g2d, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingRow == row) {
            return;
        }
        Object value = path.getLastPathComponent();
        boolean hasFocus = (((JTree)this.component).hasFocus() ? this.lastSelectionRow : -1) == row;
        boolean selected = ((JTree)this.component).isRowSelected(row);
        Component rowComponent = this.currentCellRenderer.getTreeCellRendererComponent((JTree)this.component, value, selected, isExpanded, isLeaf, row, hasFocus);
        this.rendererPane.paintComponent(g2d, rowComponent, this.component, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (isLeaf) {
            return false;
        }
        int depth = path.getPathCount() - 1;
        return depth != 0 && (depth != 1 || this.isRootVisible()) || this.getShowsRootHandles();
    }

    protected boolean isRootVisible() {
        return this.component != null && ((JTree)this.component).isRootVisible();
    }

    protected boolean getShowsRootHandles() {
        return this.component != null && ((JTree)this.component).getShowsRootHandles();
    }

    protected void paintHorizontalPartOfLeg(Graphics2D g2d, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (!this.paintLines) {
            return;
        }
        int depth = path.getPathCount() - 1;
        if ((depth == 0 || depth == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + clipBounds.width;
        int clipTop = clipBounds.y;
        int clipBottom = clipBounds.y + clipBounds.height;
        int lineY = bounds.y + bounds.height / 2;
        if (this.ltr) {
            int leftX = bounds.x - ((WebTreeUI)this.ui).getRightChildIndent();
            int nodeX = bounds.x - this.getHorizontalLegIndent();
            if (lineY >= clipTop && lineY < clipBottom && nodeX >= clipLeft && leftX < clipRight && leftX < nodeX) {
                g2d.setPaint(this.linesColor);
                this.paintHorizontalLine(g2d, lineY, leftX, nodeX - 1);
            }
        } else {
            int nodeX = bounds.x + bounds.width + this.getHorizontalLegIndent();
            int rightX = bounds.x + bounds.width + ((WebTreeUI)this.ui).getRightChildIndent();
            if (lineY >= clipTop && lineY < clipBottom && rightX >= clipLeft && nodeX < clipRight && nodeX < rightX) {
                g2d.setPaint(this.linesColor);
                this.paintHorizontalLine(g2d, lineY, nodeX, rightX - 1);
            }
        }
    }

    protected int getHorizontalLegIndent() {
        return -2;
    }

    protected void paintVerticalPartOfLeg(Graphics2D g2d, Rectangle clipBounds, Insets insets, TreePath path) {
        if (!this.paintLines) {
            return;
        }
        int depth = path.getPathCount() - 1;
        if (depth == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        int lineX = this.getRowX(-1, depth + 1);
        lineX = this.ltr ? lineX - ((WebTreeUI)this.ui).getRightChildIndent() + insets.left : ((JTree)this.component).getWidth() - lineX - insets.right + ((WebTreeUI)this.ui).getRightChildIndent() - 1;
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        if (lineX >= clipLeft && lineX <= clipRight) {
            int bottom;
            Object root;
            int clipTop = clipBounds.y;
            int clipBottom = clipBounds.y + clipBounds.height;
            Rectangle parentBounds = this.getPathBounds(path);
            Rectangle lastChildBounds = this.getPathBounds(this.getLastChildPath(path));
            if (lastChildBounds == null) {
                return;
            }
            int top = parentBounds == null ? Math.max(insets.top + this.getVerticalLegIndent(), clipTop) : Math.max(parentBounds.y + parentBounds.height + this.getVerticalLegIndent(), clipTop);
            if (depth == 0 && !this.isRootVisible() && this.treeModel != null && this.treeModel.getChildCount(root = this.treeModel.getRoot()) > 0 && (parentBounds = this.getPathBounds(path.pathByAddingChild(this.treeModel.getChild(root, 0)))) != null) {
                top = Math.max(insets.top + this.getVerticalLegIndent(), parentBounds.y + parentBounds.height / 2);
            }
            if (top <= (bottom = Math.min(lastChildBounds.y + lastChildBounds.height / 2, clipBottom))) {
                g2d.setPaint(this.linesColor);
                this.paintVerticalLine(g2d, lineX, top, bottom);
            }
        }
    }

    protected TreePath getLastChildPath(TreePath parent) {
        int childCount;
        if (this.treeModel != null && (childCount = this.treeModel.getChildCount(parent.getLastPathComponent())) > 0) {
            return parent.pathByAddingChild(this.treeModel.getChild(parent.getLastPathComponent(), childCount - 1));
        }
        return null;
    }

    protected void paintVerticalLine(Graphics2D g2d, int x, int y1, int y2) {
        if (this.dashedLines) {
            this.paintDashedVerticalLine(g2d, x, y1, y2);
        } else {
            g2d.drawLine(x, y1, x, y2);
        }
    }

    protected void paintDashedVerticalLine(Graphics2D g2d, int x, int y1, int y2) {
        y1 += y1 % 2;
        for (int y = y1; y <= y2; y += 2) {
            g2d.drawLine(x, y, x, y);
        }
    }

    protected void paintHorizontalLine(Graphics2D g2d, int y, int x1, int x2) {
        if (this.dashedLines) {
            this.paintDashedHorizontalLine(g2d, y, x1, x2);
        } else {
            g2d.drawLine(x1, y, x2, y);
        }
    }

    protected void paintDashedHorizontalLine(Graphics2D g2d, int y, int x1, int x2) {
        x1 += x1 % 2;
        for (int x = x1; x <= x2; x += 2) {
            g2d.drawLine(x, y, x, y);
        }
    }

    protected int getRowX(int row, int depth) {
        return this.totalChildIndent * (depth + this.depthOffset);
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected int getVerticalLegIndent() {
        return 0;
    }

    protected void paintDropLocation(Graphics2D g2d, Rectangle bounds, E c, U ui) {
        if (this.isDropLocationAvailable()) {
            this.dropLocationPainter.prepareToPaint(((JTree)this.component).getDropLocation());
            this.dropLocationPainter.paint(g2d, bounds, c, ui);
        }
    }

    protected boolean isDropLocationAvailable() {
        return this.dropLocationPainter != null && ((JTree)this.component).getDropLocation() != null;
    }

    protected void paintMultiselector(Graphics2D g2d) {
        if (this.isSelectorAvailable() && this.selectionStart != null && this.selectionEnd != null) {
            Rectangle sb = GeometryUtils.getContainingRect((Point[])new Point[]{this.selectionStart, this.selectionEnd});
            Rectangle fsb = sb.intersection(Bounds.component.of(this.component));
            --fsb.width;
            --fsb.height;
            this.selectorPainter.paint(g2d, fsb, this.component, this.ui);
        }
    }

    protected boolean isSelectorAvailable() {
        return this.selectorPainter != null && this.component != null && ((JTree)this.component).isEnabled() && ((JTree)this.component).getSelectionModel().getSelectionMode() != 1;
    }

    protected Rectangle getPathBounds(TreePath path) {
        if (this.component != null && this.treeState != null) {
            return this.getPathBounds(path, ((JTree)this.component).getInsets(), new Rectangle());
        }
        return null;
    }

    protected Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
        if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
            bounds.x = this.ltr ? (bounds.x += insets.left) : ((JTree)this.component).getWidth() - (bounds.x + bounds.width) - insets.right;
            bounds.y += insets.top;
        }
        return bounds;
    }

    protected boolean isFullLineSelection() {
        return ((WebTreeUI)this.ui).getSelectionStyle() == TreeSelectionStyle.line;
    }

    protected boolean isDragAvailable() {
        return this.component != null && ((JTree)this.component).isEnabled() && ((JTree)this.component).getDragEnabled() && ((JTree)this.component).getTransferHandler() != null && ((JTree)this.component).getTransferHandler().getSourceActions(this.component) > 0;
    }
}

