/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.text.AdaptivePasswordFieldPainter;
import com.alee.laf.text.IPasswordFieldPainter;
import com.alee.laf.text.PasswordFieldPainter;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CompareUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.DataRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class WebPasswordFieldUI
extends BasicPasswordFieldUI
implements Styleable,
ShapeProvider,
MarginSupport,
PaddingSupport {
    @DefaultPainter(value=PasswordFieldPainter.class)
    protected IPasswordFieldPainter painter;
    protected String inputPrompt;
    protected JPasswordField field = null;
    protected Insets margin = null;
    protected Insets padding = null;
    protected JComponent leadingComponent = null;
    protected JComponent trailingComponent = null;
    protected ComponentAdapter componentResizeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebPasswordFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.field = (JPasswordField)c;
        this.componentResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PainterSupport.updateBorder(WebPasswordFieldUI.this.getPainter());
            }
        };
        StyleManager.installSkin(this.field);
    }

    @Override
    public void uninstallUI(JComponent c) {
        StyleManager.uninstallSkin(this.field);
        this.field.putClientProperty("HANDLES_ENABLE_STATE", null);
        this.removeLeadingComponent();
        this.removeTrailingComponent();
        this.field.setLayout(null);
        this.field = null;
        super.uninstallUI(c);
    }

    @Override
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this.field);
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return StyleManager.setStyleId(this.field, id);
    }

    @Override
    public Shape provideShape() {
        return PainterSupport.getShape(this.field, this.painter);
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        PainterSupport.updateBorder(this.getPainter());
    }

    @Override
    public Insets getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(Insets padding) {
        this.padding = padding;
        PainterSupport.updateBorder(this.getPainter());
    }

    public Painter getPainter() {
        return PainterSupport.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PainterSupport.setPainter(this.field, new DataRunnable<IPasswordFieldPainter>(){

            public void run(IPasswordFieldPainter newPainter) {
                WebPasswordFieldUI.this.painter = newPainter;
            }
        }, this.painter, painter, IPasswordFieldPainter.class, AdaptivePasswordFieldPainter.class);
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("enabled")) {
            SwingUtils.setEnabledRecursively(this.leadingComponent, this.field.isEnabled());
            SwingUtils.setEnabledRecursively(this.trailingComponent, this.field.isEnabled());
        }
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String text) {
        if (!CompareUtils.equals((Object)text, (Object[])new Object[]{this.inputPrompt})) {
            this.inputPrompt = text;
            this.field.repaint();
        }
    }

    public JComponent getLeadingComponent() {
        return this.leadingComponent;
    }

    public void setLeadingComponent(JComponent leadingComponent) {
        if (this.leadingComponent == leadingComponent) {
            return;
        }
        this.removeLeadingComponent();
        if (leadingComponent != null) {
            this.leadingComponent = leadingComponent;
            this.leadingComponent.addComponentListener(this.componentResizeListener);
            this.field.add((Component)leadingComponent, "LEADING");
        }
        this.field.revalidate();
        PainterSupport.updateBorder(this.getPainter());
    }

    public void removeLeadingComponent() {
        if (this.leadingComponent != null) {
            this.leadingComponent.removeComponentListener(this.componentResizeListener);
            this.field.remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    public JComponent getTrailingComponent() {
        return this.trailingComponent;
    }

    public void setTrailingComponent(JComponent trailingComponent) {
        if (this.trailingComponent == trailingComponent) {
            return;
        }
        this.removeTrailingComponent();
        if (trailingComponent != null) {
            this.trailingComponent = trailingComponent;
            this.trailingComponent.addComponentListener(this.componentResizeListener);
            this.field.add((Component)trailingComponent, "TRAILING");
        }
        this.field.revalidate();
        PainterSupport.updateBorder(this.getPainter());
    }

    public void removeTrailingComponent() {
        if (this.trailingComponent != null) {
            this.trailingComponent.removeComponentListener(this.componentResizeListener);
            this.field.remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        if (this.painter != null) {
            ReflectUtils.setFieldValueSafely((Object)this, (String)"painted", (Object)true);
            JTextComponent c = this.getComponent();
            this.painter.paint((Graphics2D)g, Bounds.component.of(c), c, this);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps = super.getPreferredSize(c);
        ++ps.width;
        return PainterSupport.getPreferredSize(c, ps, this.painter);
    }
}

