/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.menu.AbstractMenuItemPainter;
import com.alee.laf.menu.ICheckBoxMenuItemPainter;
import com.alee.laf.menu.WebCheckBoxMenuItemUI;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class CheckBoxMenuItemPainter<E extends JMenuItem, U extends WebCheckBoxMenuItemUI>
extends AbstractMenuItemPainter<E, U>
implements ICheckBoxMenuItemPainter<E, U> {
    protected static final ImageIcon boxIcon = new ImageIcon(WebCheckBoxMenuItemUI.class.getResource("icons/box.png"));
    protected static final ImageIcon boxCheckIcon = new ImageIcon(WebCheckBoxMenuItemUI.class.getResource("icons/boxCheck.png"));
    protected Color checkColor = new Color(230, 230, 220);

    @Override
    protected void paintBackground(Graphics2D g2d, boolean selected) {
        super.paintBackground(g2d, selected);
        if (!selected && ((JMenuItem)this.component).isSelected() && this.checkColor != null) {
            g2d.setPaint(this.checkColor);
            g2d.fillRect(0, 0, ((JMenuItem)this.component).getWidth(), ((JMenuItem)this.component).getHeight());
        }
    }

    @Override
    protected void paintIcon(Graphics2D g2d, int x, int y, int w, int h, boolean selected) {
        super.paintIcon(g2d, x, y, w, h, selected);
        if (((JMenuItem)this.component).getIcon() == null) {
            int ix = x + w / 2 - boxIcon.getIconWidth() / 2;
            int iy = y + h / 2 - boxIcon.getIconHeight() / 2;
            g2d.drawImage(((JMenuItem)this.component).isSelected() ? boxCheckIcon.getImage() : boxIcon.getImage(), ix, iy, null);
        }
    }
}

