/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.laf.filechooser.FileAcceptText;
import com.alee.laf.filechooser.WebFileChooserPanel;
import com.alee.laf.filechooser.WebFileChooserUI;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.style.MarginSupport;
import com.alee.managers.style.PaddingSupport;
import com.alee.managers.style.ShapeProvider;
import com.alee.managers.style.Skin;
import com.alee.managers.style.Skinnable;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Paintable;
import com.alee.painter.Painter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.swing.Customizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class WebFileChooser
extends JFileChooser
implements Styleable,
Skinnable,
Paintable,
ShapeProvider,
MarginSupport,
PaddingSupport,
LanguageMethods,
LanguageContainerMethods {
    protected List<? extends Image> customIcons = null;

    public WebFileChooser() {
        super(FileUtils.getUserHomePath());
    }

    public WebFileChooser(String dirPath) {
        super(dirPath);
    }

    public WebFileChooser(File dir) {
        super(dir);
    }

    public WebFileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public WebFileChooser(File dir, FileSystemView fsv) {
        super(dir, fsv);
    }

    public WebFileChooser(String dirPath, FileSystemView fsv) {
        super(dirPath, fsv);
    }

    public WebFileChooser(StyleId id) {
        super(FileUtils.getUserHomePath());
        this.setStyleId(id);
    }

    public WebFileChooser(StyleId id, String dirPath) {
        super(dirPath);
        this.setStyleId(id);
    }

    public WebFileChooser(StyleId id, File dir) {
        super(dir);
        this.setStyleId(id);
    }

    public WebFileChooser(StyleId id, FileSystemView fsv) {
        super(fsv);
        this.setStyleId(id);
    }

    public WebFileChooser(StyleId id, File dir, FileSystemView fsv) {
        super(dir, fsv);
        this.setStyleId(id);
    }

    public WebFileChooser(StyleId id, String dirPath, FileSystemView fsv) {
        super(dirPath, fsv);
        this.setStyleId(id);
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        if (this.customIcons != null) {
            dialog.setIconImages(this.customIcons);
        }
        return dialog;
    }

    public Image getDialogIcon() {
        return this.customIcons != null && this.customIcons.size() > 0 ? this.customIcons.get(0) : null;
    }

    public List<? extends Image> getDialogIcons() {
        return this.customIcons;
    }

    public void setDialogIcon(ImageIcon icon) {
        this.setDialogImage(icon.getImage());
    }

    public void setDialogImage(Image icon) {
        this.setDialogImages(Arrays.asList(icon));
    }

    public void setDialogIcons(List<? extends ImageIcon> customIcons) {
        this.setDialogImages(ImageUtils.toImagesList(customIcons));
    }

    public void setDialogImages(List<? extends Image> customIcons) {
        this.customIcons = customIcons;
        Window window = SwingUtils.getWindowAncestor((Component)this);
        if (window != null && window instanceof JDialog) {
            window.setIconImages(customIcons);
        }
    }

    public void setDialogTitleKey(String dialogTitle) {
        this.setLanguage(dialogTitle, new Object[0]);
    }

    public void setCurrentDirectory(String path) {
        this.setCurrentDirectory(path != null ? new File(path) : null);
    }

    public void setSelectedFile(String path) {
        this.setSelectedFile(path != null ? new File(path) : null);
    }

    public WebFileChooserPanel getFileChooserPanel() {
        return this.getWebUI().getFileChooserPanel();
    }

    public List<AbstractFileFilter> getAvailableFilters() {
        return this.getWebUI().getAvailableFilters();
    }

    public AbstractFileFilter getActiveFileFilter() {
        return this.getWebUI().getActiveFileFilter();
    }

    public boolean isGenerateThumbnails() {
        return this.getWebUI().isGenerateThumbnails();
    }

    public void setGenerateThumbnails(boolean generate) {
        this.getWebUI().setGenerateThumbnails(generate);
    }

    public void setApproveButtonText(FileAcceptText approveText) {
        this.getWebUI().setApproveButtonText(approveText);
    }

    public void setApproveButtonLanguage(String key) {
        this.getWebUI().setApproveButtonLanguage(key);
    }

    @Override
    public StyleId getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public StyleId setStyleId(StyleId id) {
        return this.getWebUI().setStyleId(id);
    }

    @Override
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    public Skin setSkin(Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    public Skin setSkin(Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    public Skin restoreSkin() {
        return StyleManager.restoreSkin(this);
    }

    @Override
    public void addStyleListener(StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    public Map<String, Painter> getCustomPainters() {
        return StyleManager.getCustomPainters(this);
    }

    @Override
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    public Painter getCustomPainter(String id) {
        return StyleManager.getCustomPainter(this, id);
    }

    @Override
    public Painter setCustomPainter(Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public Painter setCustomPainter(String id, Painter painter) {
        return StyleManager.setCustomPainter(this, id, painter);
    }

    @Override
    public boolean restoreDefaultPainters() {
        return StyleManager.restoreDefaultPainters(this);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    @Override
    public Insets getPadding() {
        return this.getWebUI().getPadding();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int top, int left, int bottom, int right) {
        this.setPadding(new Insets(top, left, bottom, right));
    }

    @Override
    public void setPadding(Insets padding) {
        this.getWebUI().setPadding(padding);
    }

    private WebFileChooserUI getWebUI() {
        return (WebFileChooserUI)this.getUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ReflectUtils.setFieldValueSafely((Object)this, (String)"uiFileView", (Object)this.getUI().getFileView(this));
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
    }

    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (Object[])data);
    }

    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this, (String)key, (Object[])data);
    }

    public void removeLanguage() {
        LanguageManager.unregisterComponent((JComponent)this);
    }

    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent((JComponent)this);
    }

    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater((JComponent)this, (LanguageUpdater)updater);
    }

    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater((JComponent)this);
    }

    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer((Container)this, (String)key);
    }

    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer((Container)this);
    }

    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey((Container)this);
    }

    public static File showOpenDialog() {
        return WebFileChooser.showOpenDialog(null, null, null);
    }

    public static File showOpenDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(null, null, customizer);
    }

    public static File showOpenDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(parent, null, customizer);
    }

    public static File showOpenDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showOpenDialog(null, currentDirectory, customizer);
    }

    public static File showOpenDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showOpenDialog(parent, currentDirectory, null);
    }

    public static File showOpenDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(false);
        if (customizer != null) {
            customizer.customize((Object)fileChooser);
        }
        if (fileChooser.showOpenDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static List<File> showMultiOpenDialog() {
        return WebFileChooser.showMultiOpenDialog(null, null, null);
    }

    public static List<File> showMultiOpenDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(null, null, customizer);
    }

    public static List<File> showMultiOpenDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(parent, null, customizer);
    }

    public static List<File> showMultiOpenDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showMultiOpenDialog(null, currentDirectory, customizer);
    }

    public static List<File> showMultiOpenDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showMultiOpenDialog(parent, currentDirectory, null);
    }

    public static List<File> showMultiOpenDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        if (customizer != null) {
            customizer.customize((Object)fileChooser);
        }
        if (fileChooser.showOpenDialog(parent) == 0) {
            return CollectionUtils.toList((Object[])fileChooser.getSelectedFiles());
        }
        return null;
    }

    public static File showSaveDialog() {
        return WebFileChooser.showSaveDialog(null, null, null);
    }

    public static File showSaveDialog(Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(null, null, customizer);
    }

    public static File showSaveDialog(Component parent, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(parent, null, customizer);
    }

    public static File showSaveDialog(String currentDirectory, Customizer<WebFileChooser> customizer) {
        return WebFileChooser.showSaveDialog(null, currentDirectory, customizer);
    }

    public static File showSaveDialog(Component parent, String currentDirectory) {
        return WebFileChooser.showSaveDialog(parent, currentDirectory, null);
    }

    public static File showSaveDialog(Component parent, String currentDirectory, Customizer<WebFileChooser> customizer) {
        WebFileChooser fileChooser = new WebFileChooser(currentDirectory);
        fileChooser.setMultiSelectionEnabled(true);
        if (customizer != null) {
            customizer.customize((Object)fileChooser);
        }
        if (fileChooser.showSaveDialog(parent) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

