/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree.sample;

import com.alee.extended.tree.AbstractAsyncTreeDataProvider;
import com.alee.extended.tree.ChildrenListener;
import com.alee.extended.tree.sample.SampleNode;
import com.alee.extended.tree.sample.SampleNodeType;
import com.alee.utils.CollectionUtils;
import java.util.Locale;

public class SampleAsyncDataProvider
extends AbstractAsyncTreeDataProvider<SampleNode> {
    @Override
    public SampleNode getRoot() {
        return new SampleNode(SampleNodeType.root, "Root");
    }

    @Override
    public void loadChildren(SampleNode parent, ChildrenListener<SampleNode> listener) {
        if (parent.getTitle().toLowerCase(Locale.ROOT).contains("fail")) {
            listener.loadFailed(new RuntimeException("Sample exception cause"));
        } else {
            switch (parent.getType()) {
                case root: {
                    SampleNode folder1 = new SampleNode(SampleNodeType.folder, "Folder 1");
                    SampleNode folder2 = new SampleNode(SampleNodeType.folder, "Folder 2");
                    SampleNode folder3 = new SampleNode(SampleNodeType.folder, "Folder 3");
                    SampleNode failFolder = new SampleNode(SampleNodeType.folder, "Fail folder");
                    listener.loadCompleted(CollectionUtils.asList((Object[])new SampleNode[]{folder1, folder2, folder3, failFolder}));
                    break;
                }
                case folder: {
                    SampleNode leaf1 = new SampleNode(SampleNodeType.leaf, "Leaf 1");
                    SampleNode leaf2 = new SampleNode(SampleNodeType.leaf, "Leaf 2");
                    SampleNode leaf3 = new SampleNode(SampleNodeType.leaf, "Leaf 3");
                    listener.loadCompleted(CollectionUtils.asList((Object[])new SampleNode[]{leaf1, leaf2, leaf3}));
                    break;
                }
            }
        }
    }

    @Override
    public boolean isLeaf(SampleNode node) {
        return node.getType().equals((Object)SampleNodeType.leaf);
    }
}

